/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.messages;

import java.io.IOException;
import java.io.InputStream;
import rescuecore2.log.Logger;
import rescuecore2.messages.Message;
import rescuecore2.registry.AbstractMessageFactory;
import rescuecore2.standard.messages.AKClear;
import rescuecore2.standard.messages.AKExtinguish;
import rescuecore2.standard.messages.AKLoad;
import rescuecore2.standard.messages.AKMove;
import rescuecore2.standard.messages.AKRescue;
import rescuecore2.standard.messages.AKRest;
import rescuecore2.standard.messages.AKSay;
import rescuecore2.standard.messages.AKSpeak;
import rescuecore2.standard.messages.AKSubscribe;
import rescuecore2.standard.messages.AKTell;
import rescuecore2.standard.messages.AKUnload;
import rescuecore2.standard.messages.StandardMessageURN;

public final class StandardMessageFactory
extends AbstractMessageFactory<StandardMessageURN> {
    public static final StandardMessageFactory INSTANCE = new StandardMessageFactory();

    private StandardMessageFactory() {
        super(StandardMessageURN.class);
    }

    public Message makeMessage(StandardMessageURN urn, InputStream data) throws IOException {
        switch (urn) {
            case AK_REST: {
                return new AKRest(data);
            }
            case AK_MOVE: {
                return new AKMove(data);
            }
            case AK_LOAD: {
                return new AKLoad(data);
            }
            case AK_UNLOAD: {
                return new AKUnload(data);
            }
            case AK_SAY: {
                return new AKSay(data);
            }
            case AK_TELL: {
                return new AKTell(data);
            }
            case AK_EXTINGUISH: {
                return new AKExtinguish(data);
            }
            case AK_RESCUE: {
                return new AKRescue(data);
            }
            case AK_CLEAR: {
                return new AKClear(data);
            }
            case AK_SUBSCRIBE: {
                return new AKSubscribe(data);
            }
            case AK_SPEAK: {
                return new AKSpeak(data);
            }
        }
        Logger.warn((String)("Unrecognised message urn: " + (Object)((Object)urn)));
        return null;
    }
}

