/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.score;

import java.util.EnumMap;
import java.util.Map;
import rescuecore2.Timestep;
import rescuecore2.config.Config;
import rescuecore2.score.AbstractScoreFunction;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.StandardEntityConstants;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.WorldModel;

public class BuildingDamageScoreFunction
extends AbstractScoreFunction {
    private static final String HEATING_FACTOR = "score.standard.building-fire.heating";
    private static final String BURNING_FACTOR = "score.standard.building-fire.burning";
    private static final String INFERNO_FACTOR = "score.standard.building-fire.inferno";
    private static final String WATER_DAMAGE_FACTOR = "score.standard.building-fire.water-damage";
    private static final String MINOR_DAMAGE_FACTOR = "score.standard.building-fire.minor-damage";
    private static final String MODERATE_DAMAGE_FACTOR = "score.standard.building-fire.moderate-damage";
    private static final String SEVERE_DAMAGE_FACTOR = "score.standard.building-fire.severe-damage";
    private static final String BURNT_OUT_FACTOR = "score.standard.building-fire.burnt-out";
    private static final String ABSOLUTE_KEY = "score.standard.building-fire.absolute";
    private Map<StandardEntityConstants.Fieryness, Double> factors;
    private boolean absolute;

    public BuildingDamageScoreFunction() {
        super("Building damage");
    }

    public void initialise(WorldModel<? extends Entity> world, Config config) {
        this.factors = new EnumMap<StandardEntityConstants.Fieryness, Double>(StandardEntityConstants.Fieryness.class);
        this.factors.put(StandardEntityConstants.Fieryness.UNBURNT, 1.0);
        this.factors.put(StandardEntityConstants.Fieryness.HEATING, config.getFloatValue(HEATING_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.BURNING, config.getFloatValue(BURNING_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.INFERNO, config.getFloatValue(INFERNO_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.WATER_DAMAGE, config.getFloatValue(WATER_DAMAGE_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.MINOR_DAMAGE, config.getFloatValue(MINOR_DAMAGE_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.MODERATE_DAMAGE, config.getFloatValue(MODERATE_DAMAGE_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.SEVERE_DAMAGE, config.getFloatValue(SEVERE_DAMAGE_FACTOR));
        this.factors.put(StandardEntityConstants.Fieryness.BURNT_OUT, config.getFloatValue(BURNT_OUT_FACTOR));
        this.absolute = config.getBooleanValue(ABSOLUTE_KEY, false);
    }

    public double score(WorldModel<? extends Entity> world, Timestep timestep) {
        double sum = 0.0;
        double max = 0.0;
        for (Entity next : world) {
            Building b;
            if (!(next instanceof Building) || !(b = (Building)next).isTotalAreaDefined()) continue;
            int importance = b.isImportanceDefined() ? b.getImportance() : 1;
            double area = b.getTotalArea() * importance;
            StandardEntityConstants.Fieryness fire = b.getFierynessEnum();
            double factor = fire == null ? 1.0 : this.factors.get((Object)fire);
            sum += area * factor;
            max += area;
        }
        if (this.absolute) {
            return sum;
        }
        return sum / max;
    }
}

