/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.components;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import rescuecore2.components.AbstractComponent;
import rescuecore2.components.Agent;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.RequestIDGenerator;
import rescuecore2.config.Config;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionException;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.messages.Command;
import rescuecore2.messages.Message;
import rescuecore2.messages.control.AKAcknowledge;
import rescuecore2.messages.control.AKConnect;
import rescuecore2.messages.control.KAConnectError;
import rescuecore2.messages.control.KAConnectOK;
import rescuecore2.messages.control.KASense;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public abstract class AbstractAgent<T extends WorldModel<? extends Entity>, E extends Entity>
extends AbstractComponent<T>
implements Agent {
    private EntityID entityID;

    protected AbstractAgent() {
        this.config = new Config();
    }

    @Override
    public final void postConnect(Connection c, EntityID agentID, Collection<Entity> entities, Config kernelConfig) {
        this.entityID = agentID;
        super.postConnect(c, entities, kernelConfig);
    }

    @Override
    public EntityID getID() {
        return this.entityID;
    }

    @Override
    public void connect(Connection connection, RequestIDGenerator generator, Config config) throws ConnectionException, ComponentConnectionException, InterruptedException {
        this.config = config;
        int requestID = generator.generateRequestID();
        AKConnect connect = new AKConnect(requestID, 1, this.getName(), this.getRequestedEntityURNs());
        CountDownLatch latch = new CountDownLatch(1);
        AgentConnectionListener l = new AgentConnectionListener(requestID, latch);
        connection.addConnectionListener(l);
        connection.sendMessage(connect);
        latch.await();
        l.testSuccess();
    }

    @Override
    protected void postConnect() {
        super.postConnect();
    }

    @Override
    protected String getPreferredNDC() {
        if (this.me() != null) {
            return this.me().toString();
        }
        return null;
    }

    protected abstract void think(int var1, ChangeSet var2, Collection<Command> var3);

    protected void processSense(KASense sense) {
        this.model.merge(sense.getChangeSet());
        Collection<Command> heard = sense.getHearing();
        this.think(sense.getTime(), sense.getChangeSet(), heard);
    }

    protected E me() {
        if (this.entityID == null) {
            return null;
        }
        if (this.model == null) {
            return null;
        }
        return (E)this.model.getEntity(this.entityID);
    }

    @Override
    protected void processMessage(Message msg) {
        if (msg instanceof KASense) {
            KASense sense = (KASense)msg;
            if (this.entityID.equals(sense.getAgentID())) {
                this.processSense(sense);
            }
        } else {
            super.processMessage(msg);
        }
    }

    private class AgentConnectionListener
    implements ConnectionListener {
        private int requestID;
        private CountDownLatch latch;
        private ComponentConnectionException failureReason;

        public AgentConnectionListener(int requestID, CountDownLatch latch) {
            this.requestID = requestID;
            this.latch = latch;
            this.failureReason = null;
        }

        @Override
        public void messageReceived(Connection c, Message msg) {
            if (msg instanceof KAConnectOK) {
                this.handleConnectOK(c, (KAConnectOK)msg);
            }
            if (msg instanceof KAConnectError) {
                this.handleConnectError(c, (KAConnectError)msg);
            }
        }

        private void handleConnectOK(Connection c, KAConnectOK ok) {
            if (ok.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                AbstractAgent.this.postConnect(c, ok.getAgentID(), ok.getEntities(), ok.getConfig());
                try {
                    c.sendMessage(new AKAcknowledge(this.requestID, ok.getAgentID()));
                }
                catch (ConnectionException e) {
                    this.failureReason = new ComponentConnectionException(e);
                }
                this.latch.countDown();
            }
        }

        private void handleConnectError(Connection c, KAConnectError error) {
            if (error.getRequestID() == this.requestID) {
                c.removeConnectionListener(this);
                this.failureReason = new ComponentConnectionException(error.getReason());
                this.latch.countDown();
            }
        }

        void testSuccess() throws ComponentConnectionException {
            if (this.failureReason != null) {
                throw this.failureReason;
            }
        }
    }
}

