/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.messages.control;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import rescuecore2.config.Config;
import rescuecore2.messages.AbstractMessage;
import rescuecore2.messages.Control;
import rescuecore2.messages.components.ConfigComponent;
import rescuecore2.messages.components.EntityListComponent;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.messages.control.ControlMessageURN;
import rescuecore2.worldmodel.Entity;

public class KSConnectOK
extends AbstractMessage
implements Control {
    private IntComponent simulatorID = new IntComponent("Simulator ID");
    private IntComponent requestID = new IntComponent("Request ID");
    private EntityListComponent world = new EntityListComponent("Entities");
    private ConfigComponent config = new ConfigComponent("Simulator config");

    public KSConnectOK(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public KSConnectOK(int simulatorID, int requestID, Collection<? extends Entity> allEntities, Config config) {
        this();
        this.simulatorID.setValue(simulatorID);
        this.requestID.setValue(requestID);
        this.world.setEntities(allEntities);
        this.config.setConfig(config);
    }

    private KSConnectOK() {
        super(ControlMessageURN.KS_CONNECT_OK);
        this.addMessageComponent(this.requestID);
        this.addMessageComponent(this.simulatorID);
        this.addMessageComponent(this.world);
        this.addMessageComponent(this.config);
    }

    public int getSimulatorID() {
        return this.simulatorID.getValue();
    }

    public int getRequestID() {
        return this.requestID.getValue();
    }

    public Collection<Entity> getEntities() {
        return this.world.getEntities();
    }

    public Config getConfig() {
        return this.config.getConfig();
    }
}

