/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.view;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import rescuecore2.config.Config;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.view.Icons;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewLayer;

public class LayerViewComponent
extends ViewComponent {
    private Config config;
    private List<ViewLayer> layers = new ArrayList<ViewLayer>();
    private Map<ViewLayer, Action> layerActions = new HashMap<ViewLayer, Action>();
    private Object[] data;
    private Rectangle2D bounds;

    public LayerViewComponent() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    LayerViewComponent.this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    LayerViewComponent.this.showPopupMenu(e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    @Override
    public void initialise(Config c) {
        this.config = c;
        for (ViewLayer next : this.layers) {
            next.initialise(this.config);
        }
    }

    public void addLayer(ViewLayer layer) {
        this.layers.add(layer);
        layer.setLayerViewComponent(this);
        this.layerActions.put(layer, new LayerAction(layer));
        if (this.config != null) {
            layer.initialise(this.config);
        }
        this.computeBounds();
    }

    public void removeLayer(ViewLayer layer) {
        int index = this.layers.indexOf(layer);
        if (index != -1) {
            this.layers.remove(index);
            this.layerActions.remove(layer);
            layer.setLayerViewComponent(null);
            this.computeBounds();
        }
    }

    public void removeAllLayers() {
        for (ViewLayer next : this.layers) {
            next.setLayerViewComponent(null);
        }
        this.layers.clear();
        this.layerActions.clear();
        this.computeBounds();
    }

    @Override
    public void view(Object ... objects) {
        this.data = objects;
        this.computeBounds();
        super.view(objects);
    }

    @Override
    protected Collection<RenderedObject> render(Graphics2D g, ScreenTransform transform, int width, int height) {
        HashSet<RenderedObject> result = new HashSet<RenderedObject>();
        this.prepaint();
        for (ViewLayer next : this.layers) {
            if (!next.isVisible()) continue;
            Graphics2D copy = (Graphics2D)g.create();
            result.addAll(next.render(copy, transform, width, height));
        }
        this.postpaint();
        return result;
    }

    protected List<ViewLayer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    protected void prepaint() {
    }

    protected void postpaint() {
    }

    private void computeBounds() {
        Rectangle2D oldBounds = this.bounds;
        this.bounds = null;
        for (ViewLayer next : this.layers) {
            this.expandBounds(next.view(this.data));
        }
        if (this.bounds == null) {
            this.updateBounds(0.0, 0.0, 1.0, 1.0);
        } else if (oldBounds == null || oldBounds.getMinX() != this.bounds.getMinX() || oldBounds.getMinY() != this.bounds.getMinY() || oldBounds.getMaxX() != this.bounds.getMaxX() || oldBounds.getMaxY() != this.bounds.getMaxY()) {
            this.updateBounds(this.bounds.getMinX(), this.bounds.getMinY(), this.bounds.getMaxX(), this.bounds.getMaxY());
        }
    }

    private void expandBounds(Rectangle2D next) {
        if (next == null) {
            return;
        }
        if (this.bounds == null) {
            this.bounds = next;
        } else {
            Rectangle2D.union(this.bounds, next, this.bounds);
        }
    }

    private void showPopupMenu(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        for (ViewLayer next : this.layers) {
            List<JMenuItem> items;
            Action action = this.layerActions.get(next);
            JMenu layerMenu = new JMenu(next.getName());
            layerMenu.add(new JMenuItem(action));
            if (next.isVisible() && (items = next.getPopupMenuItems()) != null && !items.isEmpty()) {
                layerMenu.addSeparator();
                for (JMenuItem item : items) {
                    layerMenu.add(item);
                }
            }
            menu.add(layerMenu);
        }
        menu.show(this, x, y);
    }

    private class LayerAction
    extends AbstractAction {
        private ViewLayer layer;

        public LayerAction(ViewLayer layer) {
            super("Visible");
            this.layer = layer;
            this.putValue("SwingSelectedKey", layer.isVisible());
            this.putValue("SmallIcon", layer.isVisible() ? Icons.TICK : Icons.CROSS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean selected = (Boolean)this.getValue("SwingSelectedKey");
            this.putValue("SwingSelectedKey", !selected);
            this.putValue("SmallIcon", !selected ? Icons.TICK : Icons.CROSS);
            this.layer.setVisible(!selected);
            LayerViewComponent.this.repaint();
        }
    }
}

