package org.util.xml;

import java.awt.event.KeyEvent;
import java.net.SocketAddress;
import javax.swing.event.DocumentEvent;
import org.util.xml.parse.ElementParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import org.util.xml.element.Element;
import org.util.xml.element.TagElement;
import org.util.xml.parse.policy.HTMLParserPolicy;
import org.util.xml.parse.policy.ParserPolicy;
import org.util.xml.parse.policy.XMLParserPolicy;

/**
 *
 * @author masaru
 */
public class Main3 {
    
    JTextArea textarea1 = new JTextArea();
    JTextArea textarea2 = new JTextArea();
    //JTextArea textarea3 = new JTextArea();
    JPanel buttonpane = new JPanel();
    ParserPolicy policy_ = null;
    JTextField tabtext_;
    JTextField filtertext_;
    JTextField urltext_;
    Proxy proxy_;
    DocumentListener dl_;
    
    public static void main(String[] args) throws Exception {
        new Main3();
    }

    public Main3() {
        dl_ = new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                changedUpdate(e);
            }

            public void changedUpdate(final DocumentEvent e) {
                try{
                    int length = e.getDocument().getLength();
                    String text = e.getDocument().getText(0, length);
                    startParse(text);
                }catch(Exception exc) {
                    exc.printStackTrace();
                }
            }
        };
        textarea1.getDocument().addDocumentListener(dl_);
        
        final JRadioButton htmlmode = new JRadioButton(new AbstractAction("html mode"){

            public void actionPerformed(ActionEvent arg0) {
                policy_ = new HTMLParserPolicy() {
                    @Override
                    public Element allowElement(Element element) {
                        super.allowElement(element);
                        if(element.isTextElement()) return element;
                        TagElement tag = (TagElement)element;
                        if(tag.getKey().toLowerCase().matches(filtertext_.getText()))
                            return element;
                        else
                            return null;
                    }
                    @Override
                    public boolean throwExceptionIfDocumentHasError() {
                        return false;
                    }
                };
                startParse(textarea1.getText());
            }
            
        });
        final JRadioButton xmlmode = new JRadioButton(new AbstractAction("xml mode"){

            public void actionPerformed(ActionEvent arg0) {
                policy_ = new XMLParserPolicy() {
                    @Override
                    public Element allowElement(Element element) {
                        super.allowElement(element);
                        if(element.isTextElement()) return element;
                        TagElement tag = (TagElement)element;
                        if(tag.getKey().toLowerCase().matches(filtertext_.getText()))
                            return element;
                        else
                            return null;
                    }
                    @Override
                    public boolean throwExceptionIfDocumentHasError() {
                        return true;
                    }
                    
                };
                startParse(textarea1.getText());
            }
            
        });
        
        ButtonGroup group = new ButtonGroup();
        group.add(htmlmode);
        group.add(xmlmode);
        KeyAdapter watch_key = new KeyAdapter(){
            @Override
            public void keyTyped(KeyEvent ke) {
                startParse(textarea1.getText());
            }
        };
        buttonpane.add(htmlmode);
        buttonpane.add(xmlmode);
        tabtext_=new JTextField(" ", 10);
        tabtext_.addKeyListener(watch_key);
        filtertext_ = new JTextField(".*", 10);
        filtertext_.addKeyListener(watch_key);
        buttonpane.add(tabtext_);
        buttonpane.add(filtertext_);
        urltext_ = new JTextField();
        urltext_.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                String url = ((JTextField)e.getSource()).getText();
                openURL(url);
            }
        });

        buttonpane.add(new JButton(new AbstractAction("set proxy") {

            public void actionPerformed(ActionEvent arg0) {
                String host = JOptionPane.showInputDialog("http://[hostname]:[port]\n1. input proxy hostname");
                String port = JOptionPane.showInputDialog("http://[hostname]:[port]\n2. input proxy port");
                proxy_ = new Proxy(Proxy.Type.HTTP, InetSocketAddress(host, Integer.parseInt(port)));
            }

            private SocketAddress InetSocketAddress(String host, int parseInt) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }));
        
        JPanel panel = new JPanel(new GridLayout(1,3));
        panel.add(new JScrollPane(textarea1));
        panel.add(new JScrollPane(textarea2));
        //panel.add(new JScrollPane(textarea3));
/*
        JTextField textfield = new JTextField("http://www.google.com/");
        textfield.addActionListener(new ActionListener(){
            public void actionPerformed(final ActionEvent e) {
                new Thread(new Runnable(){public void run(){
                    openURL(((JTextField)e.getSource()).getText());
                }}).start();
            }
        });
*/
        
        JPanel contentpane = new JPanel(new BorderLayout());
        contentpane.add(urltext_, BorderLayout.NORTH);
        contentpane.add(panel,BorderLayout.CENTER);
        contentpane.add(buttonpane,BorderLayout.SOUTH);
        contentpane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setContentPane(contentpane);
        frame.setSize(200,200);
        frame.setLocation(100,100);
        frame.setVisible(true);

        xmlmode.doClick();
    }
    
    public void startParse(final String text) {
        new Thread(new Runnable(){public void run(){
	    ElementParser parser = null;
            try{
                // System.out.println(textarea1.getText());

//                InputStream is = new ByteArrayInputStream(text.getBytes(encoding));
//                ElementParser parser = new ElementParser(is);
                Reader reader = new StringReader(text);
                parser = new ElementParser(reader);
                parser.setPolicy(policy_);
                parser.parse();
                Element[] elements = parser.getResult();
                StringBuffer sb = new StringBuffer();
                for(int i=0;i<elements.length;i++) {
                    elements[i].setTabText(tabtext_.getText());
                    sb.append(elements[i].toString());
                }
                textarea2.setForeground(Color.black);
                textarea2.setText(sb.toString());
                textarea2.revalidate();
            } catch(Exception exc) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exc.printStackTrace(pw);
                textarea2.setForeground(Color.red);;
                textarea2.setText(sw.toString());
		textarea2.append("\n------------------------\n");
		if(parser!=null) {
		    StringBuffer sb = new StringBuffer();
		    Element[] elements = parser.getResult();
		    if(elements != null)
		    for(int i=0;i<elements.length;i++) {
			elements[i].setTabText(tabtext_.getText());
			sb.append(elements[i].toString());
		    }
		    textarea2.append(sb.toString());
		}
                textarea2.revalidate();
            }
        }
        }).start();
    }
    public void openURL(final String urltext) {
        new Thread(new Runnable(){public void run(){
            try{
                URL url = new URL(urltext);
                InputStream is = ( proxy_!=null ? url.openConnection(proxy_).getInputStream() : url.openStream() );
                ElementParser parser = new ElementParser(is);
                parser.setPolicy(new HTMLParserPolicy(){
			@Override
			public boolean throwExceptionIfDocumentHasError(){
			    return false;
			}
		    });
                parser.parse();
                String encoding = parser.getEncoding();
                if(encoding.equals("unknown"))
                    encoding = JOptionPane.showInputDialog("input encoding","utf-8");
                is.close();
                is = ( proxy_!=null ? url.openConnection(proxy_).getInputStream() : url.openStream() );
                BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
                textarea1.read(br, "text/plain");
                textarea1.getDocument().addDocumentListener(dl_);
                startParse(textarea1.getText());
            } catch(Exception exc) {
                JOptionPane.showMessageDialog(null, exc);
            }
        }
        }).start();
    }
}