/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.io;

import org.util.xml.parse.policy.*;
import org.util.xml.parse.*;
import org.util.xml.element.*;
import java.net.*;
import java.io.*;

/**
 *
 * @author masaru
 */
public class XMLIO {

    public static TagElement read(StringBuffer xml_text) throws IOException, XMLParseException {
        return read(new StringReader(xml_text.toString()));
    }
    public static TagElement read(URL url) throws IOException, XMLParseException {
        return read(url.openStream());
    }
    public static TagElement read(URL url, String encoding) throws IOException, XMLParseException {
        return read(url.openStream(), encoding);
    }
    public static TagElement read(String file_name_or_url) throws IOException, XMLParseException {
        return read(findURL(file_name_or_url));
    }
    public static TagElement read(String file_name_or_url, String encoding) throws IOException, XMLParseException {
        return read(new URL(file_name_or_url), encoding);
    }
    public static TagElement read(File file) throws IOException, XMLParseException {
        return read(file.toURI().toURL());
    }
    public static TagElement read(File file, String encoding) throws IOException, XMLParseException {
        return read(file.toURI().toURL(), encoding);
    }
    public static TagElement read(InputStream in, String encoding) throws IOException, XMLParseException {
        return read(new InputStreamReader(in, encoding));
    }
    public static TagElement read(InputStream in) throws IOException, XMLParseException {
        ElementParser parser = new ElementParser(in);
        parser.setPolicy(new XMLParserPolicy());
        parser.parse();
        return parser.getFirstPlainTagElement();
    }
    public static TagElement read(Reader r) throws IOException, XMLParseException {
        ElementParser parser = new ElementParser(r);
        parser.setPolicy(new XMLParserPolicy());
        parser.parse();
        return parser.getFirstPlainTagElement();
    }

    protected static URL findURL(String name) throws IOException, XMLParseException {
        File file = new File(name);
        if(file.exists()) {
            return file.toURI().toURL();
        }
        URL url = ClassLoader.getSystemResource(name);
        if(url != null) {
            return url;
        }
        throw new IOException("cannot find resource: "+name);
    }

    public static void write(File file, Element element) throws IOException, XMLParseException {
        write(new FileWriter(file), element);
    }

    public static void write(Writer writer, Element element) throws IOException, XMLParseException {
        element.write(writer);
    }
}
