/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.util.xml.parse;

import java.io.IOException;
import org.util.xml.parse.ElementParser;

/**
 * parse space.
 * S ::= (#x20 | #x9 | #xD | #xA)+
 * <a href="http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#NT-S">W3C REC-xml-980210</a>
 * @author masaru
 */
public class TextElementParser extends ParseElement {

    private String return_value_;

    public boolean match(char c) {
        return allow(c);
    }

    @Override
        public int parse(int c,ElementParser parser) throws XMLParseException, IOException {
        StringBuffer sb = new StringBuffer();
        int next_word_ = -1;
        int state = 0;
        while(c!=-1) {
            if(state == 0) {
                if(allow(c)) {
                    sb.append((char)c);
                    state = 1;
                } else throw new XMLParseException("parse error: cannot read text :"+c);
            } else if (state == 1) {
                if (allow(c)) {
                    sb.append((char)c);
                }else {
                    next_word_ = c;
                    break;
                }
            }
            c = parser.get();
        }
        return_value_ = sb.toString();
        return next_word_;
    }
    
    @Override
    public String getReturnValue() {
        return return_value_;
    }
    
    public boolean allow(int c) {
        return ((c!='<') && (c!='>') && (c!=-1));
    }
}
