package org.gui;

import java.io.*;
import java.net.*;
import java.awt.*;
import javax.swing.*;
import java.awt.dnd.*;
import java.awt.datatransfer.*;

public class GUITool {

	private static java.util.ArrayList<JFrame> frame_list_ = new java.util.ArrayList<JFrame>();
	private static JFileChooser file_chooser_;

	public static boolean tryToSetSystemLookAndFeel() throws Exception {
		boolean result = true;
		try{
			String system_laf_name = UIManager.getSystemLookAndFeelClassName();
			UIManager.setLookAndFeel(system_laf_name);
		}catch(Exception e){ result = false; }
		return result;
	}

	public static File[] openFiles(JComponent parent, String button_name) throws Exception {
		JFileChooser file_chooser = getFileChooser();
		if(button_name==null)
			button_name = "open";
		int result = file_chooser.showDialog(parent, button_name);
		if(result != JFileChooser.APPROVE_OPTION) throw new UsarCancelException("usarcanceld");
		File[] file_list = file_chooser.getSelectedFiles();
		return file_list;
	}

	public static File openFile(JComponent parent, String button_name) throws Exception {
		JFileChooser file_chooser = getFileChooser();
		if(button_name==null)
			button_name = "open";
		int result = file_chooser.showDialog(parent, button_name);
		if(result != JFileChooser.APPROVE_OPTION) throw new UsarCancelException("usar canceld");
		File file = file_chooser.getSelectedFile();
		return file;
	}

	public static JFileChooser getFileChooser() throws Exception {
		if(file_chooser_ == null) {
			file_chooser_ = new JFileChooser();
			JPanel panel = new JPanel(new BorderLayout());
			JTextPane ta = new JTextPane();
			ta.setContentType("text/html");
			ta.setText("<html><br/><div style='text-align:center;'>Drop Area</div></html>");
			ta.setPreferredSize(new Dimension(100, 100));
			ta.setEditable(false);
			ta.setBorder(BorderFactory.createLineBorder(Color.black));
			// ta.setLineWrap(true);
			panel.add(ta, BorderLayout.CENTER);
			panel.setBorder(BorderFactory.createEmptyBorder(0,20,0,0));
//			JComponent component = panel;
			FileInputer inputer = new FileInputer(){
				public void openFile(File... file) {
					file_chooser_.setSelectedFiles(file);
				}
			};
			setFileInputer(ta, ta, inputer);
			file_chooser_.setAccessory(panel);
			file_chooser_.setMultiSelectionEnabled(true);
		}
		return file_chooser_;
	}
	
    public static JFrame showFrame(JComponent component) {
	return showFrame(component, JFrame.DO_NOTHING_ON_CLOSE);
    }

    public static JFrame showFrame(JComponent component, int close_operation) {
		JFrame frame = new JFrame();
		frame.setContentPane(component);
		frame.setDefaultCloseOperation(close_operation);
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
		frame_list_.add(frame);
		return frame;
	}

    public static void alert(Object message) {
	JOptionPane.showMessageDialog(null, message);
    }












    public static void setFileInputer(JComponent component,final JTextPane message_label, final FileInputer inputer) throws Exception {
		DropTarget dt = new DropTarget();
		dt.addDropTargetListener(new DropTargetAdapter(){
			public void dragEnter(DropTargetDragEvent dtde) {
				try{
					Transferable transferable_data = dtde.getTransferable();
					if(transferable_data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
						String text = (String)transferable_data.getTransferData(DataFlavor.stringFlavor);
						if(message_label != null) {
						    //message_label.setText(text);
							message_label.setText("<html><br/><div style='text-align:center;'>"+text+"</div></html>");
						}
						dtde.acceptDrag(DnDConstants.ACTION_COPY);
					} else if(transferable_data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)){
						Object tmp = transferable_data.getTransferData(DataFlavor.javaFileListFlavor);
						java.util.List<File> file_list = castList(tmp);
						StringBuffer text = new StringBuffer();
						for(int i=0;i<file_list.size();i++)
							text.append(file_list.get(i).getAbsolutePath()+"\n");
						if(message_label != null) {
						    //message_label.setText(text.toString());
						    message_label.setText("<html><br/><div style='text-align:center;'>"+text+"</div></html>");
						}
						dtde.acceptDrag(DnDConstants.ACTION_COPY);
					} else {
						if(message_label != null) {
							String text = "unknown data type.";
							//message_label.setText(text);
							message_label.setText("<html><br/><div style='text-align:center;'>"+text+"</div></html>");
						}
						dtde.rejectDrag();
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			public void dragExit(DropTargetEvent dtde) {
				if(message_label != null)
					message_label.setText("drop area");
			}
			public void drop(DropTargetDropEvent dtde){
				boolean success = false;
				dtde.acceptDrop(DnDConstants.ACTION_COPY);
				try{
					Transferable transferable_data = dtde.getTransferable();
					if(transferable_data.isDataFlavorSupported(DataFlavor.stringFlavor)) {
						String text = (String)transferable_data.getTransferData(DataFlavor.stringFlavor);
						text = text.replaceAll("\r\n", "\n").replaceAll("\r","\n");
						String[] uri_text_list = text.split("\n");
						final File[] file_list = new File[uri_text_list.length];
						for(int i=0;i<uri_text_list.length;i++)
							file_list[i] = new File(new URI(uri_text_list[i]));
						inputer.openFile(file_list);
						success = true;
					} else if(transferable_data.isDataFlavorSupported(DataFlavor.javaFileListFlavor)){
						Object tmp = transferable_data.getTransferData(DataFlavor.javaFileListFlavor);
						java.util.List<File> file_list = castList(tmp);
						inputer.openFile(file_list.toArray(new File[0]));
						success = true;
					} else {
						StringBuffer sb = new StringBuffer();
						DataFlavor[] dfs = transferable_data.getTransferDataFlavors();
						for(int i=0;i<dfs.length;i++) {
							sb.append(dfs[i].getMimeType());
							sb.append("(");
							sb.append(dfs[i].toString());
							sb.append(")\n");
						}
						throw new Exception("Unsupported data type.\n"+sb.toString());
					}
				}catch(Exception e){
					e.printStackTrace();
				}
				if(message_label != null)
				    message_label.setText("<html><br/><div style='text-align:center;'>Drop Area</div></html>");
				//message_label.setText("drop area");
				dtde.dropComplete(success);
			}
		});
		component.setDropTarget(dt);
	}




    public static void setFileInputer(JComponent component, final FileInputer inputer) throws Exception {
	setFileInputer(component, null, inputer);
    }




	@SuppressWarnings("unchecked")
	private static <E> java.util.List<E> castList(Object list) {
	    return (java.util.List<E>)list;
	}
}
