package libsvm.wrapper;

import libsvm.svm_node;

/**
 * <pre>
 * 特徴
 * (svm_node)
 * </pre>
 *
 * @author hirai
 */
public class SvmFeature {

	private int featureId;
	private double value;

	/**
	 * コンストラクタ
	 *
	 * @param featureId 特徴ID
	 * @param value 特徴の値
	 */
	public SvmFeature(int featureId, double value) {
		this.featureId = featureId;
		this.value = value;
	}

	/**
	 * @return 特徴ID
	 */
	public int getFeatureId() {
		return featureId;
	}

	/**
	 * @return 特徴量
	 */
	public double getValue() {
		return value;
	}

	/**
	 * 利用可能な状態に変換します．
	 *
	 * @return
	 */
	public svm_node toUsable() {

		svm_node res = new svm_node();

		res.index = this.featureId;
		res.value = this.value;

		return res;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + featureId;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SvmFeature other = (SvmFeature) obj;
		if (featureId != other.featureId)
			return false;
		return true;
	}
}
