/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.HashSet;
import javax.swing.JOptionPane;
import maps.gml.GMLNode;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import rescuecore2.log.Logger;

public class FixNearbyNodesFunction
extends ProgressFunction {
    private static final double DEFAULT_TOLERANCE = 0.001;
    private double tolerance;

    public FixNearbyNodesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Fix nearby nodes";
    }

    @Override
    protected String getTitle() {
        return "Fixing nearby nodes";
    }

    @Override
    public void execute() {
        String s = JOptionPane.showInputDialog(this.editor.getViewer(), "Enter the desired tolerance (in m)", 0.001);
        if (s == null) {
            return;
        }
        this.tolerance = Double.parseDouble(s);
        super.execute();
    }

    @Override
    protected void executeImpl() {
        HashSet<GMLNode> remaining = new HashSet<GMLNode>(this.editor.getMap().getNodes());
        this.setProgressLimit(remaining.size());
        int count = 0;
        while (!remaining.isEmpty()) {
            GMLNode next = (GMLNode)remaining.iterator().next();
            remaining.remove(next);
            double x = next.getX();
            double y = next.getY();
            this.bumpProgress();
            for (GMLNode replaced : this.editor.getMap().getNodesInRegion(x - this.tolerance, y - this.tolerance, x + this.tolerance, y + this.tolerance)) {
                if (replaced == next) continue;
                this.editor.getMap().replaceNode(replaced, next);
                remaining.remove(replaced);
                this.editor.getMap().removeNode(replaced);
                ++count;
                this.bumpProgress();
            }
        }
        if (count != 0) {
            this.editor.setChanged();
            this.editor.getViewer().repaint();
        }
        Logger.debug((String)("Removed " + count + " nodes"));
    }
}

