/*
 * Decompiled with CFR 0.152.
 */
package collapse;

import collapse.CollapseSimulatorGUI;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.uncommons.maths.Maths;
import org.uncommons.maths.number.NumberGenerator;
import org.uncommons.maths.random.ContinuousUniformGenerator;
import org.uncommons.maths.random.GaussianGenerator;
import rescuecore2.GUIComponent;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.control.KSCommands;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.Vector2D;
import rescuecore2.standard.components.StandardSimulator;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Edge;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityConstants;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.Property;
import rescuecore2.worldmodel.WorldModel;
import rescuecore2.worldmodel.WorldModelListener;

public class CollapseSimulator
extends StandardSimulator
implements GUIComponent {
    private static final String CONFIG_PREFIX = "collapse.";
    private static final String DESTROYED_SUFFIX = ".p-destroyed";
    private static final String SEVERE_SUFFIX = ".p-severe";
    private static final String MODERATE_SUFFIX = ".p-moderate";
    private static final String SLIGHT_SUFFIX = ".p-slight";
    private static final String NONE_SUFFIX = ".p-none";
    private static final String DESTROYED_MEAN_SUFFIX = "destroyed.mean";
    private static final String DESTROYED_SD_SUFFIX = "destroyed.sd";
    private static final String SEVERE_MEAN_SUFFIX = "severe.mean";
    private static final String SEVERE_SD_SUFFIX = "severe.sd";
    private static final String MODERATE_MEAN_SUFFIX = "moderate.mean";
    private static final String MODERATE_SD_SUFFIX = "moderate.sd";
    private static final String SLIGHT_MEAN_SUFFIX = "slight.mean";
    private static final String SLIGHT_SD_SUFFIX = "slight.sd";
    private static final String BLOCK_KEY = "collapse.create-road-blockages";
    private static final String FLOOR_HEIGHT_KEY = "collapse.floor-height";
    private static final String WALL_COLLAPSE_EXTENT_MIN_KEY = "collapse.wall-extent.min";
    private static final String WALL_COLLAPSE_EXTENT_MAX_KEY = "collapse.wall-extent.max";
    private static final int MAX_COLLAPSE = 100;
    private static final double REPAIR_COST_FACTOR = 1.0E-6;
    private static final List<EntityID> EMPTY_ID_LIST = new ArrayList<EntityID>(0);
    private NumberGenerator<Double> destroyed;
    private NumberGenerator<Double> severe;
    private NumberGenerator<Double> moderate;
    private NumberGenerator<Double> slight;
    private boolean block;
    private double floorHeight;
    private NumberGenerator<Double> extent;
    private Map<StandardEntityConstants.BuildingCode, CollapseStats> stats;
    private CollapseSimulatorGUI gui;
    private Collection<Building> buildingCache;
    private Collection<Road> roadCache;

    public JComponent getGUIComponent() {
        if (this.gui == null) {
            this.gui = new CollapseSimulatorGUI();
        }
        return this.gui;
    }

    public String getGUIComponentName() {
        return "Collapse simulator";
    }

    public String getName() {
        return "Basic collapse simulator";
    }

    protected void postConnect() {
        super.postConnect();
        this.stats = new EnumMap<StandardEntityConstants.BuildingCode, CollapseStats>(StandardEntityConstants.BuildingCode.class);
        for (StandardEntityConstants.BuildingCode code : StandardEntityConstants.BuildingCode.values()) {
            this.stats.put(code, new CollapseStats(code, this.config));
        }
        this.slight = new GaussianGenerator(this.config.getFloatValue("collapse.slight.mean"), this.config.getFloatValue("collapse.slight.sd"), this.config.getRandom());
        this.moderate = new GaussianGenerator(this.config.getFloatValue("collapse.moderate.mean"), this.config.getFloatValue("collapse.moderate.sd"), this.config.getRandom());
        this.severe = new GaussianGenerator(this.config.getFloatValue("collapse.severe.mean"), this.config.getFloatValue("collapse.severe.sd"), this.config.getRandom());
        this.destroyed = new GaussianGenerator(this.config.getFloatValue("collapse.destroyed.mean"), this.config.getFloatValue("collapse.destroyed.sd"), this.config.getRandom());
        this.block = this.config.getBooleanValue(BLOCK_KEY);
        this.floorHeight = this.config.getFloatValue(FLOOR_HEIGHT_KEY) * 1000.0;
        this.extent = new ContinuousUniformGenerator(this.config.getFloatValue(WALL_COLLAPSE_EXTENT_MIN_KEY), this.config.getFloatValue(WALL_COLLAPSE_EXTENT_MAX_KEY), this.config.getRandom());
        this.buildingCache = new HashSet<Building>();
        this.roadCache = new HashSet<Road>();
        for (StandardEntity next : (StandardWorldModel)this.model) {
            if (next instanceof Building) {
                this.buildingCache.add((Building)next);
            }
            if (!(next instanceof Road)) continue;
            this.roadCache.add((Road)next);
        }
        ((StandardWorldModel)this.model).addWorldModelListener((WorldModelListener)new WorldModelListener<StandardEntity>(){

            public void entityAdded(WorldModel<? extends StandardEntity> model, StandardEntity e) {
                if (e instanceof Building) {
                    CollapseSimulator.this.buildingCache.add((Building)e);
                }
                if (e instanceof Road) {
                    CollapseSimulator.this.roadCache.add((Road)e);
                }
            }

            public void entityRemoved(WorldModel<? extends StandardEntity> model, StandardEntity e) {
                if (e instanceof Building) {
                    CollapseSimulator.this.buildingCache.remove((Building)e);
                }
                if (e instanceof Road) {
                    CollapseSimulator.this.roadCache.remove((Road)e);
                }
            }
        });
    }

    protected void processCommands(KSCommands c, ChangeSet changes) {
        long start = System.currentTimeMillis();
        int time = c.getTime();
        Logger.info((String)("Timestep " + time));
        if (this.gui != null) {
            this.gui.timestep(time);
        }
        Collection<Building> collapsed = this.doCollapse(changes, time);
        Map<Road, Collection<java.awt.geom.Area>> newBlock = this.doBlock(collapsed);
        Map<Road, Collection<Blockade>> blockades = this.createBlockadeObjects(newBlock);
        for (Map.Entry<Road, Collection<Blockade>> entry : blockades.entrySet()) {
            Road r = entry.getKey();
            List existing = r.getBlockades();
            ArrayList<EntityID> ids = new ArrayList<EntityID>();
            if (existing != null) {
                ids.addAll(existing);
            }
            for (Blockade b : entry.getValue()) {
                ids.add(b.getID());
            }
            r.setBlockades(ids);
            changes.addAll(entry.getValue());
            changes.addChange((Entity)r, (Property)r.getBlockadesProperty());
        }
        for (Road next : this.roadCache) {
            if (next.isBlockadesDefined()) continue;
            next.setBlockades(EMPTY_ID_LIST);
            changes.addChange((Entity)next, (Property)next.getBlockadesProperty());
        }
        long end = System.currentTimeMillis();
        Logger.info((String)("Timestep " + time + " took " + (end - start) + " ms"));
    }

    private Collection<Building> doCollapse(ChangeSet changes, int time) {
        HashSet<Building> result = new HashSet<Building>();
        if (this.gui != null) {
            this.gui.startCollapse(this.buildingCache.size());
        }
        if (time == 1) {
            result.addAll(this.doEarthquakeCollapse(changes));
        }
        if (this.gui != null) {
            this.gui.endCollapse();
        }
        if (this.gui != null) {
            this.gui.startFire(this.buildingCache.size());
        }
        if (this.gui != null) {
            this.gui.endFire();
        }
        return result;
    }

    private Map<Road, Collection<java.awt.geom.Area>> doBlock(Collection<Building> collapsed) {
        LazyMap<Road, Collection<java.awt.geom.Area>> result = new LazyMap<Road, Collection<java.awt.geom.Area>>(){

            public Collection<java.awt.geom.Area> createValue() {
                return new ArrayList<java.awt.geom.Area>();
            }
        };
        if (!this.block) {
            return result;
        }
        if (this.gui != null) {
            this.gui.startBlock(collapsed.size());
        }
        for (Building b : collapsed) {
            this.createBlockages(b, (Map<Road, Collection<java.awt.geom.Area>>)result);
            if (this.gui == null) continue;
            this.gui.bumpBlock();
        }
        if (this.gui != null) {
            this.gui.endBlock();
        }
        return result;
    }

    private Collection<Building> doEarthquakeCollapse(ChangeSet changes) {
        EnumMap count = new EnumMap(StandardEntityConstants.BuildingCode.class);
        EnumMap<StandardEntityConstants.BuildingCode, Integer> total = new EnumMap<StandardEntityConstants.BuildingCode, Integer>(StandardEntityConstants.BuildingCode.class);
        for (StandardEntityConstants.BuildingCode code : StandardEntityConstants.BuildingCode.values()) {
            EnumMap<CollapseDegree, Integer> next = new EnumMap<CollapseDegree, Integer>(CollapseDegree.class);
            for (CollapseDegree cd : CollapseDegree.values()) {
                next.put(cd, 0);
            }
            count.put(code, next);
            total.put(code, 0);
        }
        Logger.debug((String)"Collapsing buildings");
        HashSet<Building> result = new HashSet<Building>();
        for (Building b : this.buildingCache) {
            StandardEntityConstants.BuildingCode code;
            code = b.getBuildingCodeEnum();
            int damage = code == null ? 0 : this.stats.get(code).damage();
            damage = Maths.restrictRange((int)damage, (int)0, (int)100);
            b.setBrokenness(damage);
            changes.addChange((Entity)b, (Property)b.getBrokennessProperty());
            CollapseDegree degree = CollapseDegree.get(damage);
            ((Map)count.get(code)).put(degree, (Integer)((Map)count.get(code)).get((Object)degree) + 1);
            total.put(code, (Integer)total.get(code) + 1);
            if (damage > 0) {
                result.add(b);
            }
            if (this.gui == null) continue;
            this.gui.bumpCollapse();
        }
        Logger.info((String)"Finished collapsing buildings: ");
        for (StandardEntityConstants.BuildingCode code : StandardEntityConstants.BuildingCode.values()) {
            Logger.info((String)("Building code " + code + ": " + total.get(code) + " buildings"));
            Map data = (Map)count.get(code);
            for (Map.Entry entry : data.entrySet()) {
                Logger.info((String)("  " + entry.getValue() + " " + ((CollapseDegree)((Object)entry.getKey())).toString().toLowerCase()));
            }
        }
        return result;
    }

    private Collection<Building> doFireCollapse(ChangeSet changes) {
        Logger.debug((String)"Checking fire damage");
        HashSet<Building> result = new HashSet<Building>();
        for (Building b : this.buildingCache) {
            int damage;
            if (!b.isFierynessDefined()) {
                if (this.gui == null) continue;
                this.gui.bumpFire();
                continue;
            }
            int minDamage = 0;
            switch (b.getFierynessEnum()) {
                case HEATING: {
                    minDamage = ((Double)this.slight.nextValue()).intValue();
                    break;
                }
                case BURNING: {
                    minDamage = ((Double)this.moderate.nextValue()).intValue();
                    break;
                }
                case INFERNO: {
                    minDamage = ((Double)this.severe.nextValue()).intValue();
                    break;
                }
                case BURNT_OUT: {
                    minDamage = ((Double)this.destroyed.nextValue()).intValue();
                    break;
                }
            }
            minDamage = Maths.restrictRange((int)minDamage, (int)0, (int)100);
            int n = damage = b.isBrokennessDefined() ? b.getBrokenness() : 0;
            if (damage < minDamage) {
                Logger.info((String)(b + " damaged by fire. New brokenness: " + minDamage));
                b.setBrokenness(minDamage);
                changes.addChange((Entity)b, (Property)b.getBrokennessProperty());
                result.add(b);
            }
            if (this.gui == null) continue;
            this.gui.bumpFire();
        }
        Logger.debug((String)"Finished checking fire damage");
        return result;
    }

    private Map<Road, Collection<Blockade>> createBlockadeObjects(Map<Road, Collection<java.awt.geom.Area>> blocks) {
        LazyMap<Road, Collection<Blockade>> result = new LazyMap<Road, Collection<Blockade>>(){

            public Collection<Blockade> createValue() {
                return new ArrayList<Blockade>();
            }
        };
        int count = 0;
        for (Collection<java.awt.geom.Area> c : blocks.values()) {
            count += c.size();
        }
        try {
            if (count != 0) {
                List newIDs = this.requestNewEntityIDs(count);
                Iterator it = newIDs.iterator();
                Logger.debug((String)"Creating new blockade objects");
                for (Map.Entry<Road, Collection<java.awt.geom.Area>> entry : blocks.entrySet()) {
                    Road r = entry.getKey();
                    for (java.awt.geom.Area area : entry.getValue()) {
                        EntityID id = (EntityID)it.next();
                        Blockade blockade = this.makeBlockade(id, area, r.getID());
                        if (blockade == null) continue;
                        ((Collection)result.get(r)).add(blockade);
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Logger.error((String)"Interrupted while requesting IDs");
        }
        return result;
    }

    private void createBlockages(Building b, Map<Road, Collection<java.awt.geom.Area>> roadBlockages) {
        Logger.debug((String)("Creating blockages for " + b));
        double d = this.floorHeight * (double)b.getFloors() * ((double)b.getBrokenness() / 100.0) * (Double)this.extent.nextValue();
        ArrayList<java.awt.geom.Area> wallAreas = new ArrayList<java.awt.geom.Area>();
        for (Edge edge : b.getEdges()) {
            this.projectWall(edge, wallAreas, d);
        }
        java.awt.geom.Area fullArea = new java.awt.geom.Area();
        for (java.awt.geom.Area wallArea : wallAreas) {
            fullArea.add(wallArea);
        }
        java.awt.geom.Area existing = new java.awt.geom.Area();
        for (StandardEntity e : ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.BLOCKADE)) {
            Blockade blockade = (Blockade)e;
            existing.add(this.blockadeToArea(blockade));
        }
        Map<Road, Collection<java.awt.geom.Area>> blockadesForRoads = this.createRoadBlockades(fullArea, existing);
        for (Map.Entry<Road, Collection<java.awt.geom.Area>> entry : blockadesForRoads.entrySet()) {
            Road r = entry.getKey();
            Collection<java.awt.geom.Area> c = entry.getValue();
            roadBlockages.get(r).addAll(c);
        }
    }

    private void projectWall(Edge edge, Collection<java.awt.geom.Area> areaList, double d) {
        Line2D wallLine = new Line2D((double)edge.getStartX(), (double)edge.getStartY(), (double)(edge.getEndX() - edge.getStartX()), (double)(edge.getEndY() - edge.getStartY()));
        Vector2D wallDirection = wallLine.getDirection();
        Vector2D offset = wallDirection.getNormal().normalised().scale(-d);
        Path2D.Double path = new Path2D.Double();
        Point2D first = wallLine.getOrigin();
        Point2D second = wallLine.getEndPoint();
        Point2D third = second.plus(offset);
        Point2D fourth = first.plus(offset);
        ((Path2D)path).moveTo(first.getX(), first.getY());
        ((Path2D)path).lineTo(second.getX(), second.getY());
        ((Path2D)path).lineTo(third.getX(), third.getY());
        ((Path2D)path).lineTo(fourth.getX(), fourth.getY());
        java.awt.geom.Area wallArea = new java.awt.geom.Area(path);
        areaList.add(wallArea);
        double radius = offset.getLength();
        Ellipse2D.Double ellipse1 = new Ellipse2D.Double(first.getX() - radius, first.getY() - radius, radius * 2.0, radius * 2.0);
        Ellipse2D.Double ellipse2 = new Ellipse2D.Double(second.getX() - radius, second.getY() - radius, radius * 2.0, radius * 2.0);
        areaList.add(new java.awt.geom.Area(ellipse1));
        areaList.add(new java.awt.geom.Area(ellipse2));
    }

    private Map<Road, Collection<java.awt.geom.Area>> createRoadBlockades(java.awt.geom.Area buildingArea, java.awt.geom.Area existing) {
        HashMap<Road, Collection<java.awt.geom.Area>> result = new HashMap<Road, Collection<java.awt.geom.Area>>();
        Rectangle rectangle = buildingArea.getBounds();
        Collection roads = ((StandardWorldModel)this.model).getObjectsInRectangle((int)rectangle.getMinX(), (int)rectangle.getMinY(), (int)rectangle.getMaxX(), (int)rectangle.getMaxY());
        for (StandardEntity e : roads) {
            if (!(e instanceof Road)) continue;
            Road r = (Road)e;
            java.awt.geom.Area roadArea = this.areaToGeomArea((Area)r);
            java.awt.geom.Area intersection = new java.awt.geom.Area(roadArea);
            intersection.intersect(buildingArea);
            intersection.subtract(existing);
            if (intersection.isEmpty()) continue;
            existing.add(intersection);
            List<java.awt.geom.Area> blockadeAreas = this.fix(intersection);
            result.put(r, blockadeAreas);
        }
        return result;
    }

    private java.awt.geom.Area areaToGeomArea(Area area) {
        Path2D.Double result = new Path2D.Double();
        Iterator it = area.getEdges().iterator();
        Edge e = (Edge)it.next();
        ((Path2D)result).moveTo(e.getStartX(), e.getStartY());
        ((Path2D)result).lineTo(e.getEndX(), e.getEndY());
        while (it.hasNext()) {
            e = (Edge)it.next();
            ((Path2D)result).lineTo(e.getEndX(), e.getEndY());
        }
        return new java.awt.geom.Area(result);
    }

    private List<java.awt.geom.Area> fix(java.awt.geom.Area area) {
        ArrayList<java.awt.geom.Area> result = new ArrayList<java.awt.geom.Area>();
        if (area.isSingular()) {
            result.add(area);
            return result;
        }
        PathIterator it = area.getPathIterator(null);
        Path2D current = null;
        double[] d = new double[6];
        while (!it.isDone()) {
            switch (it.currentSegment(d)) {
                case 0: {
                    if (current != null) {
                        result.add(new java.awt.geom.Area(current));
                    }
                    current = new Path2D.Double();
                    current.moveTo(d[0], d[1]);
                    break;
                }
                case 1: {
                    current.lineTo(d[0], d[1]);
                    break;
                }
                case 2: {
                    current.quadTo(d[0], d[1], d[2], d[3]);
                    break;
                }
                case 3: {
                    current.curveTo(d[0], d[1], d[2], d[3], d[4], d[5]);
                    break;
                }
                case 4: {
                    current.closePath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected result from PathIterator.currentSegment: " + it.currentSegment(d));
                }
            }
            it.next();
        }
        if (current != null) {
            result.add(new java.awt.geom.Area(current));
        }
        return result;
    }

    private Blockade makeBlockade(EntityID id, java.awt.geom.Area area, EntityID roadID) {
        if (area.isEmpty()) {
            return null;
        }
        Blockade result = new Blockade(id);
        int[] apexes = this.getApexes(area);
        List points = GeometryTools2D.vertexArrayToPoints((int[])apexes);
        if (points.size() < 2) {
            return null;
        }
        int cost = (int)(GeometryTools2D.computeArea((List)points) * 1.0E-6);
        if (cost == 0) {
            return null;
        }
        Point2D centroid = GeometryTools2D.computeCentroid((List)points);
        result.setApexes(apexes);
        result.setPosition(roadID);
        result.setX((int)centroid.getX());
        result.setY((int)centroid.getY());
        result.setRepairCost(cost);
        return result;
    }

    private int[] getApexes(java.awt.geom.Area area) {
        ArrayList<Integer> apexes = new ArrayList<Integer>();
        PathIterator it = area.getPathIterator(null, 100.0);
        double[] d = new double[6];
        int moveX = 0;
        int moveY = 0;
        int lastX = 0;
        int lastY = 0;
        boolean finished = false;
        while (!finished && !it.isDone()) {
            int x = 0;
            int y = 0;
            switch (it.currentSegment(d)) {
                case 0: {
                    x = (int)d[0];
                    y = (int)d[1];
                    moveX = x;
                    moveY = y;
                    break;
                }
                case 1: {
                    x = (int)d[0];
                    y = (int)d[1];
                    if (x != moveX || y != moveY) break;
                    finished = true;
                    break;
                }
                case 2: {
                    x = (int)d[2];
                    y = (int)d[3];
                    if (x != moveX || y != moveY) break;
                    finished = true;
                    break;
                }
                case 3: {
                    x = (int)d[4];
                    y = (int)d[5];
                    if (x != moveX || y != moveY) break;
                    finished = true;
                    break;
                }
                case 4: {
                    finished = true;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected result from PathIterator.currentSegment: " + it.currentSegment(d));
                }
            }
            if (!(finished || x == lastX && y == lastY)) {
                apexes.add(x);
                apexes.add(y);
            }
            lastX = x;
            lastY = y;
            it.next();
        }
        int[] result = new int[apexes.size()];
        int i = 0;
        for (Integer next : apexes) {
            result[i++] = next;
        }
        return result;
    }

    private java.awt.geom.Area blockadeToArea(Blockade b) {
        Path2D.Double result = new Path2D.Double();
        int[] apexes = b.getApexes();
        ((Path2D)result).moveTo(apexes[0], apexes[1]);
        for (int i = 2; i < apexes.length; i += 2) {
            ((Path2D)result).lineTo(apexes[i], apexes[i + 1]);
        }
        result.closePath();
        return new java.awt.geom.Area(result);
    }

    private static enum CollapseDegree {
        NONE(0),
        SLIGHT(25),
        MODERATE(50),
        SEVERE(75),
        DESTROYED(100);

        private int max;

        private CollapseDegree(int max) {
            this.max = max;
        }

        public static CollapseDegree get(int d) {
            for (CollapseDegree next : CollapseDegree.values()) {
                if (d > next.max) continue;
                return next;
            }
            throw new IllegalArgumentException("Don't know what to do with a damage value of " + d);
        }
    }

    private class CollapseStats {
        private double pDestroyed;
        private double pSevere;
        private double pModerate;
        private double pSlight;

        CollapseStats(StandardEntityConstants.BuildingCode code, Config config) {
            String s = CollapseSimulator.CONFIG_PREFIX + code.toString().toLowerCase();
            this.pDestroyed = config.getFloatValue(s + CollapseSimulator.DESTROYED_SUFFIX);
            this.pSevere = this.pDestroyed + config.getFloatValue(s + CollapseSimulator.SEVERE_SUFFIX);
            this.pModerate = this.pSevere + config.getFloatValue(s + CollapseSimulator.MODERATE_SUFFIX);
            this.pSlight = this.pModerate + config.getFloatValue(s + CollapseSimulator.SLIGHT_SUFFIX);
        }

        int damage() {
            double d = CollapseSimulator.this.random.nextDouble();
            if (d < this.pDestroyed) {
                return ((Double)CollapseSimulator.this.destroyed.nextValue()).intValue();
            }
            if (d < this.pSevere) {
                return ((Double)CollapseSimulator.this.severe.nextValue()).intValue();
            }
            if (d < this.pModerate) {
                return ((Double)CollapseSimulator.this.moderate.nextValue()).intValue();
            }
            if (d < this.pSlight) {
                return ((Double)CollapseSimulator.this.slight.nextValue()).intValue();
            }
            return 0;
        }
    }
}

