/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.messages;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import rescuecore2.messages.AbstractCommand;
import rescuecore2.messages.MessageComponent;
import rescuecore2.messages.components.EntityIDListComponent;
import rescuecore2.messages.components.IntComponent;
import rescuecore2.standard.messages.StandardMessageURN;
import rescuecore2.worldmodel.EntityID;

public class AKMove
extends AbstractCommand {
    private EntityIDListComponent path = new EntityIDListComponent("Path");
    private IntComponent x = new IntComponent("Destination X");
    private IntComponent y = new IntComponent("Destination Y");

    public AKMove(InputStream in) throws IOException {
        this();
        this.read(in);
    }

    public AKMove(EntityID agent, int time, List<EntityID> path) {
        this();
        this.setAgentID(agent);
        this.setTime(time);
        this.path.setIDs(path);
        this.x.setValue(-1);
        this.y.setValue(-1);
    }

    public AKMove(EntityID agent, int time, List<EntityID> path, int destinationX, int destinationY) {
        this();
        this.setAgentID(agent);
        this.setTime(time);
        this.path.setIDs(path);
        this.x.setValue(destinationX);
        this.y.setValue(destinationY);
    }

    private AKMove() {
        super((Enum)StandardMessageURN.AK_MOVE);
        this.addMessageComponent((MessageComponent)this.path);
        this.addMessageComponent((MessageComponent)this.x);
        this.addMessageComponent((MessageComponent)this.y);
    }

    public List<EntityID> getPath() {
        return this.path.getIDs();
    }

    public int getDestinationX() {
        return this.x.getValue();
    }

    public int getDestinationY() {
        return this.y.getValue();
    }
}

