/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import rescuecore.Connection;
import rescuecore.InputBuffer;
import rescuecore.LongUDPConnection;
import rescuecore.RescueComponent;
import rescuecore.RescueMessage;
import rescuecore.TCPConnection;
import rescuecore.commands.Command;

public class Launch {
    private static Collection components;
    private static final int TIMEOUT = 60000;
    private static final String UDP_FLAG = "-u";
    private static final String UDP_LONG_FLAG = "--udp";

    public static void main(String[] args) {
        boolean help = false;
        boolean tcp = true;
        components = new ArrayList();
        InetAddress kernel = null;
        int kernelPort = -1;
        if (args.length < 3) {
            Launch.printUsage();
            return;
        }
        try {
            kernel = InetAddress.getByName(args[0]);
            kernelPort = Integer.parseInt(args[1]);
        }
        catch (UnknownHostException e) {
            System.out.println("Bad host name: " + args[0]);
            Launch.printUsage();
            return;
        }
        catch (NumberFormatException e) {
            System.out.println("Bad host port: " + args[1]);
            Launch.printUsage();
            return;
        }
        ArrayList<Info> launch = new ArrayList<Info>();
        for (int i = 2; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase(UDP_FLAG) || args[i].equalsIgnoreCase(UDP_LONG_FLAG)) {
                    tcp = false;
                    continue;
                }
                System.out.println("Unrecognised option: " + args[i]);
                Launch.printUsage();
                continue;
            }
            File file = new File(args[i]);
            if (file.exists()) {
                System.out.println("I don't handle files yet. Try again later.");
                continue;
            }
            try {
                Info info = new Info(args[i]);
                launch.add(info);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        long start = System.currentTimeMillis();
        for (Info next : launch) {
            try {
                System.out.println("Launching " + (next.number == 0 ? "lots of" : "" + next.number) + " components of class " + next.clazz.getName());
                int max = next.number;
                if (max < 1) {
                    max = Integer.MAX_VALUE;
                }
                for (int j = 0; j < max; ++j) {
                    RescueComponent component = Launch.instantiate(next);
                    Connection connection = tcp ? new TCPConnection(kernel, kernelPort) : new LongUDPConnection(kernel, kernelPort);
                    component.setConnection(connection);
                    if (!Launch.launch(component, connection)) {
                        connection.close();
                        break;
                    }
                    InputThread input = new InputThread(connection, component);
                    input.start();
                    components.add(new ComponentInfo(component, input, connection));
                }
                System.out.println("Finished launching components of class " + next.clazz.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        System.out.println("Launched all components in " + (double)(end - start) / 1000.0 + " s");
        boolean running = true;
        while (running) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Iterator it = components.iterator();
            while (it.hasNext()) {
                RescueComponent c = ((ComponentInfo)it.next()).component;
                if (c.isRunning()) continue;
                running = false;
            }
        }
        Launch.shutdown();
    }

    private static void printUsage() {
        System.out.println("Usage: Launch hostname portnumber components [options]");
        System.out.println("hostname:\tThe name of the machine running the simulation kernel");
        System.out.println("portnumber:\tThe port number that the kernel is listening on");
        System.out.println("components:\tA set of components that should be launched. These are all of the form \"[number] classname arguments\". This will launch <number> (default 1) objects of type <classname>, passing <arguments> to each component.");
        System.out.println("Options");
        System.out.println("=======");
        System.out.println("-u\t--udp\tUse UDP instead of TCP");
    }

    private static RescueComponent instantiate(Info info) throws InstantiationException, IllegalAccessException, ClassNotFoundException, InvocationTargetException {
        RescueComponent result;
        if (info.args.length != 0) {
            try {
                Constructor c = info.clazz.getDeclaredConstructor(String[].class);
                result = (RescueComponent)c.newInstance(new Object[]{info.args});
            }
            catch (NoSuchMethodException e) {
                try {
                    Class[] classes = new Class[info.args.length];
                    for (int j = 0; j < classes.length; ++j) {
                        classes[j] = String.class;
                    }
                    Constructor c = info.clazz.getDeclaredConstructor(classes);
                    result = (RescueComponent)c.newInstance(info.args);
                }
                catch (NoSuchMethodException ex) {
                    result = (RescueComponent)info.clazz.newInstance();
                }
            }
        } else {
            result = (RescueComponent)info.clazz.newInstance();
        }
        return result;
    }

    private static boolean launch(RescueComponent c, Connection connection) throws IOException {
        System.out.println("Launching " + c);
        RescueMessage msg = new RescueMessage();
        msg.append(c.generateConnectCommand());
        int okReply = -1;
        int errorReply = -1;
        switch (c.getComponentType()) {
            case 1: {
                okReply = 66;
                errorReply = 67;
                break;
            }
            case 2: {
                okReply = 35;
                errorReply = 36;
                break;
            }
            case 3: {
                okReply = 50;
                errorReply = 51;
                break;
            }
            default: {
                throw new RuntimeException("Unknown component type");
            }
        }
        connection.send(msg.toByteArray());
        long timeout = System.currentTimeMillis() + 60000L;
        boolean success = false;
        do {
            try {
                byte[] reply = connection.receive(60000);
                if (reply == null) continue;
                InputBuffer in = new InputBuffer(reply);
                Command[] messages = in.readCommands();
                for (int i = 0; i < messages.length; ++i) {
                    String reason;
                    if (success) {
                        c.handleMessage(messages[i]);
                        continue;
                    }
                    if (messages[i].getType() == okReply) {
                        success = c.handleConnectOK(messages[i]);
                    }
                    if (messages[i].getType() != errorReply || (reason = c.handleConnectError(messages[i])) == null) continue;
                    System.out.println("Error connecting " + c + ": " + reason);
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
        } while (!success && System.currentTimeMillis() < timeout);
        if (!success) {
            System.out.println("Timeout trying to connect " + c);
        }
        return success;
    }

    private static void shutdown() {
        for (ComponentInfo next : components) {
            next.component.shutdown();
            next.input.kill();
        }
        for (ComponentInfo next : components) {
            next.input.killAndWait();
        }
        System.exit(0);
    }

    private static class Info {
        Class clazz;
        int number;
        String[] args;

        Info(String line) throws ClassNotFoundException, NoSuchElementException {
            String second;
            StringTokenizer tokens = new StringTokenizer(line);
            String first = tokens.nextToken();
            this.number = 1;
            try {
                this.number = Integer.parseInt(first);
                second = tokens.nextToken();
            }
            catch (NumberFormatException e) {
                second = first;
            }
            this.clazz = Class.forName(second);
            this.args = new String[tokens.countTokens()];
            for (int i = 0; i < this.args.length; ++i) {
                this.args[i] = tokens.nextToken();
            }
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append(this.clazz.getName());
            result.append("(");
            for (int i = 0; i < this.args.length; ++i) {
                result.append("\"");
                result.append(this.args[i]);
                result.append("\"");
                if (i >= this.args.length - 1) continue;
                result.append(",");
            }
            result.append(")");
            return result.toString();
        }
    }

    private static class ComponentInfo {
        RescueComponent component;
        InputThread input;
        Connection connection;

        public ComponentInfo(RescueComponent c, InputThread i, Connection connection) {
            this.component = c;
            this.input = i;
            this.connection = connection;
        }
    }

    private static class InputThread
    extends Thread {
        private volatile boolean running;
        private volatile boolean alive;
        private final Object aliveLock = new Object();
        private RescueComponent target;
        private Connection connection;

        InputThread(Connection connection, RescueComponent target) {
            this.connection = connection;
            this.target = target;
            this.alive = true;
            this.running = true;
        }

        public void kill() {
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killAndWait() {
            this.kill();
            Object object = this.aliveLock;
            synchronized (object) {
                while (this.alive) {
                    try {
                        this.aliveLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.connection.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                try {
                    byte[] msg = this.connection.receive(1000);
                    if (msg == null) continue;
                    Command[] messages = new InputBuffer(msg).readCommands();
                    for (int i = 0; i < messages.length; ++i) {
                        this.target.handleMessage(messages[i]);
                    }
                }
                catch (InterruptedException e) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.running = false;
                }
            }
            Object object = this.aliveLock;
            synchronized (object) {
                this.alive = false;
                this.aliveLock.notifyAll();
            }
        }
    }
}

