/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.commands;

import rescuecore.Handy;
import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.commands.AgentCommand;

public class AKMove
extends AgentCommand {
    private int[] path;

    public AKMove(int senderID, int time, int[] path) {
        super(129, senderID, time);
        this.path = new int[path.length];
        System.arraycopy(path, 0, this.path, 0, path.length);
    }

    public AKMove(InputBuffer in) {
        super(129, 0, 0);
        this.read(in);
    }

    @Override
    public void read(InputBuffer in) {
        super.read(in);
        this.path = new int[in.readInt()];
        for (int i = 0; i < this.path.length; ++i) {
            this.path[i] = in.readInt();
        }
    }

    @Override
    public void write(OutputBuffer out) {
        super.write(out);
        out.writeInt(this.path.length);
        for (int i = 0; i < this.path.length; ++i) {
            out.writeInt(this.path[i]);
        }
    }

    public int[] getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return "AK_MOVE (" + Handy.arrayAsString(this.path) + ")";
    }
}

