/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.MovingObject;

public abstract class Humanoid
extends MovingObject {
    private IntProperty stamina;
    private IntProperty hp;
    private IntProperty damage;
    private IntProperty buriedness;

    public Humanoid() {
        this.stamina = new IntProperty(42);
        this.hp = new IntProperty(43);
        this.damage = new IntProperty(44);
        this.buriedness = new IntProperty(45);
    }

    public Humanoid(int pos, int extra, int dir, int[] history, int stam, int health, int dmg, int bury) {
        super(pos, extra, dir, history);
        this.stamina = new IntProperty(42, stam);
        this.hp = new IntProperty(43, health);
        this.damage = new IntProperty(44, dmg);
        this.buriedness = new IntProperty(45, bury);
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 42: {
                return this.stamina;
            }
            case 43: {
                return this.hp;
            }
            case 44: {
                return this.damage;
            }
            case 45: {
                return this.buriedness;
            }
        }
        return super.getProperty(property);
    }

    public int getStamina() {
        return this.stamina.getValue();
    }

    public boolean setStamina(int s, int timestamp, Object source) {
        if (this.stamina.updateValue(s, timestamp, source)) {
            this.firePropertyChanged(42, timestamp, source);
            return true;
        }
        return false;
    }

    public int getHP() {
        return this.hp.getValue();
    }

    public boolean setHP(int h, int timestamp, Object source) {
        if (this.hp.updateValue(h, timestamp, source)) {
            this.firePropertyChanged(43, timestamp, source);
            return true;
        }
        return false;
    }

    public int getDamage() {
        return this.damage.getValue();
    }

    public boolean setDamage(int d, int timestamp, Object source) {
        if (this.damage.updateValue(d, timestamp, source)) {
            this.firePropertyChanged(44, timestamp, source);
            return true;
        }
        return false;
    }

    public int getBuriedness() {
        return this.buriedness.getValue();
    }

    public boolean setBuriedness(int b, int timestamp, Object source) {
        if (this.buriedness.updateValue(b, timestamp, source)) {
            this.firePropertyChanged(45, timestamp, source);
            return true;
        }
        return false;
    }

    public boolean isHurt() {
        return this.getHP() < 10000;
    }

    public boolean isAlive() {
        return this.getHP() > 0;
    }

    public boolean isBuried() {
        return this.getBuriedness() > 0;
    }

    public boolean isDamaged() {
        return this.getDamage() > 0;
    }
}

