/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Shape;
import rescuecore.Memory;
import rescuecore.objects.Building;
import rescuecore.view.MapRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;
import rescuecore.view.ViewConstants;

public abstract class BuildingRenderer
implements MapRenderer {
    private static final BuildingRenderer ORDINARY = new OrdinaryBuildingRenderer();

    public static BuildingRenderer ordinaryBuildingRenderer() {
        return ORDINARY;
    }

    public static BuildingRenderer filledBuildingRenderer(int fillMode, Color colour) {
        return new FilledBuildingRenderer(fillMode, colour);
    }

    public static BuildingRenderer outlinedBuildingRenderer(int outlineMode, Color colour) {
        return new OutlinedBuildingRenderer(outlineMode, colour);
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof Building;
    }

    private static class OutlinedBuildingRenderer
    extends BuildingRenderer {
        private int mode;
        private Color colour;

        OutlinedBuildingRenderer(int mode, Color colour) {
            this.mode = mode;
            this.colour = colour;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
            Building b = (Building)o;
            int[] apexes = b.getApexes();
            int[] xs = new int[apexes.length / 2];
            int[] ys = new int[apexes.length / 2];
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = transform.toScreenX(apexes[i * 2]);
                ys[i] = transform.toScreenY(apexes[i * 2 + 1]);
            }
            RenderTools.setLineMode(g, this.mode, this.colour);
            g.drawPolygon(xs, ys, xs.length);
            return new Polygon(xs, ys, xs.length);
        }
    }

    private static class FilledBuildingRenderer
    extends BuildingRenderer {
        private int mode;
        private Color colour;

        FilledBuildingRenderer(int mode, Color colour) {
            this.mode = mode;
            this.colour = colour;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
            Building b = (Building)o;
            int[] apexes = b.getApexes();
            int[] xs = new int[apexes.length / 2];
            int[] ys = new int[apexes.length / 2];
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = transform.toScreenX(apexes[i * 2]);
                ys[i] = transform.toScreenY(apexes[i * 2 + 1]);
            }
            RenderTools.setFillMode(g, this.mode, this.colour);
            g.fillPolygon(xs, ys, xs.length);
            return new Polygon(xs, ys, xs.length);
        }
    }

    private static class OrdinaryBuildingRenderer
    extends BuildingRenderer {
        private OrdinaryBuildingRenderer() {
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
            Building b = (Building)o;
            int[] apexes = b.getApexes();
            int[] xs = new int[apexes.length / 2];
            int[] ys = new int[apexes.length / 2];
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = transform.toScreenX(apexes[i * 2]);
                ys[i] = transform.toScreenY(apexes[i * 2 + 1]);
            }
            int fieryness = b.getFieryness();
            Color colour = ViewConstants.BUILDING_COLOUR;
            if (b.isFireStation()) {
                colour = ViewConstants.FIRE_STATION_COLOUR;
            }
            if (b.isAmbulanceCenter()) {
                colour = ViewConstants.AMBULANCE_CENTER_COLOUR;
            }
            if (b.isPoliceOffice()) {
                colour = ViewConstants.POLICE_OFFICE_COLOUR;
            }
            if (b.isRefuge()) {
                colour = ViewConstants.REFUGE_COLOUR;
            }
            switch (fieryness) {
                case 1: {
                    colour = ViewConstants.HEATING_COLOUR;
                    break;
                }
                case 2: {
                    colour = ViewConstants.FIRE_COLOUR;
                    break;
                }
                case 3: {
                    colour = ViewConstants.INFERNO_COLOUR;
                    break;
                }
                case 4: {
                    colour = ViewConstants.WATER_DAMAGE_COLOUR;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    colour = ViewConstants.EXTINGUISHED_COLOUR;
                    break;
                }
                case 8: {
                    colour = ViewConstants.BURNT_OUT_COLOUR;
                }
            }
            RenderTools.setFillMode(g, 0, colour);
            g.fillPolygon(xs, ys, xs.length);
            RenderTools.setLineMode(g, 0, Color.black);
            g.drawPolygon(xs, ys, xs.length);
            return new Polygon(xs, ys, xs.length);
        }
    }
}

