/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import rescuecore.view.Map;
import rescuecore.view.ObjectSelectionEvent;
import rescuecore.view.ObjectSelectionListener;

public class ObjectSelector
implements MouseListener {
    private Collection<ObjectSelectionListener> listeners = new ArrayList<ObjectSelectionListener>();
    private MousePressInfo mouseInfo = new MousePressInfo();
    private Map map;

    public ObjectSelector() {
    }

    public ObjectSelector(Map map) {
        this();
        this.setMap(map);
    }

    public void setMap(Map newMap) {
        if (this.map != null) {
            this.map.removeMouseListener(this);
        }
        if (newMap != null && newMap != this.map) {
            newMap.addMouseListener(this);
        }
        this.map = newMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectSelectionListener(ObjectSelectionListener l) {
        Collection<ObjectSelectionListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectSelectionListener(ObjectSelectionListener l) {
        Collection<ObjectSelectionListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.map == null) {
            return;
        }
        Point p = e.getPoint();
        if (this.mouseInfo.closeTo(p) && this.mouseInfo.objects != null && this.mouseInfo.objects.length > 0) {
            this.fireObjectSelected(this.mouseInfo.advancePointer());
        } else {
            Object[] objects = this.map.getObjectsAtPoint(p);
            this.mouseInfo.newPoint(p, objects);
            if (objects.length > 0) {
                this.fireObjectSelected(objects[0]);
            } else {
                this.fireObjectSelected(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireObjectSelected(Object o) {
        ObjectSelectionListener[] l;
        ObjectSelectionEvent e = new ObjectSelectionEvent(this.map, o);
        Collection<ObjectSelectionListener> collection = this.listeners;
        synchronized (collection) {
            l = this.listeners.toArray(new ObjectSelectionListener[0]);
        }
        for (int i = 0; i < l.length; ++i) {
            l[i].objectSelected(e);
        }
    }

    private class MousePressInfo {
        Point p;
        Object[] objects;
        int index;

        private MousePressInfo() {
        }

        public boolean closeTo(Point point) {
            if (this.p == null || point == null) {
                return false;
            }
            return Math.abs(this.p.x - point.x) < 2 && Math.abs(this.p.y - point.y) < 2;
        }

        public Object advancePointer() {
            ++this.index;
            if (this.index >= this.objects.length) {
                this.index = 0;
            }
            System.out.println("Selected object " + this.index + " of " + this.objects.length);
            return this.objects[this.index];
        }

        public Object newPoint(Point p, Object[] objects) {
            this.p = p;
            this.objects = objects;
            this.index = 0;
            return objects.length > 0 ? objects[0] : null;
        }
    }
}

