/*
 * Decompiled with CFR 0.152.
 */
package maps.gml.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import maps.gml.GMLDirectedEdge;
import maps.gml.GMLEdge;
import maps.gml.GMLMap;
import maps.gml.GMLNode;
import maps.gml.GMLObject;
import maps.gml.GMLShape;
import maps.gml.editor.GMLEditor;
import maps.gml.editor.ProgressFunction;
import rescuecore2.log.Logger;

public class FixDegenerateShapesFunction
extends ProgressFunction {
    public FixDegenerateShapesFunction(GMLEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Fix degenerate shapes";
    }

    @Override
    protected String getTitle() {
        return "Fixing degenerate shapes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeImpl() {
        GMLMap gMLMap;
        HashSet<GMLShape> shapes = new HashSet<GMLShape>();
        HashSet<GMLEdge> edges = new HashSet<GMLEdge>();
        GMLMap gMLMap2 = this.editor.getMap();
        synchronized (gMLMap2) {
            shapes.addAll(this.editor.getMap().getAllShapes());
            edges.addAll(this.editor.getMap().getEdges());
        }
        this.setProgressLimit(shapes.size() + edges.size());
        int shapeCount = 0;
        int spurCount = 0;
        int edgeCount = 0;
        int outlineCount = 0;
        for (GMLShape gMLShape : shapes) {
            gMLMap = this.editor.getMap();
            synchronized (gMLMap) {
                this.removeDuplicateEdges(gMLShape);
                if (this.checkForDegenerateShape(gMLShape)) {
                    ++shapeCount;
                } else {
                    if (this.checkForSpurs(gMLShape)) {
                        ++spurCount;
                    }
                    if (!this.checkOutline(gMLShape)) {
                        ++outlineCount;
                        this.editor.getMap().remove((GMLObject)gMLShape);
                    }
                }
            }
            this.bumpProgress();
        }
        for (GMLEdge gMLEdge : edges) {
            gMLMap = this.editor.getMap();
            synchronized (gMLMap) {
                if (this.checkForDegenerateEdge(gMLEdge)) {
                    ++edgeCount;
                }
            }
            this.bumpProgress();
        }
        Logger.debug((String)("Removed " + shapeCount + " degenerate shapes and " + edgeCount + " edges"));
        Logger.debug((String)("Removed " + outlineCount + " shapes with broken outlines"));
        Logger.debug((String)("Fixed " + spurCount + " spurs"));
        this.editor.setChanged();
        this.editor.getViewer().repaint();
    }

    private void removeDuplicateEdges(GMLShape shape) {
        ArrayList<GMLDirectedEdge> result = new ArrayList<GMLDirectedEdge>(shape.getEdges());
        HashSet<GMLEdge> seen = new HashSet<GMLEdge>();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            GMLDirectedEdge dEdge = (GMLDirectedEdge)it.next();
            GMLEdge edge = dEdge.getEdge();
            if (seen.contains(edge)) {
                it.remove();
            }
            seen.add(edge);
        }
        this.editor.getMap().remove((GMLObject)shape);
        shape.reorderEdges(result);
        this.editor.getMap().add((GMLObject)shape);
    }

    private boolean checkForSpurs(GMLShape shape) {
        boolean spur = false;
        ArrayList<GMLDirectedEdge> good = new ArrayList<GMLDirectedEdge>(shape.getEdges().size());
        for (GMLDirectedEdge dEdge : shape.getEdges()) {
            GMLNode start = dEdge.getStartNode();
            GMLNode end = dEdge.getEndNode();
            if (this.isFound(start, shape, dEdge) && this.isFound(end, shape, dEdge)) {
                good.add(dEdge);
                continue;
            }
            spur = true;
        }
        if (spur) {
            this.editor.getMap().remove((GMLObject)shape);
            shape.reorderEdges(good);
            this.editor.getMap().add((GMLObject)shape);
        }
        return spur;
    }

    private boolean checkOutline(GMLShape shape) {
        List<GMLDirectedEdge> edges = shape.getEdges();
        ArrayList<GMLDirectedEdge> result = new ArrayList<GMLDirectedEdge>(edges.size());
        HashSet<GMLEdge> seen = new HashSet<GMLEdge>();
        GMLDirectedEdge dEdge = edges.get(0);
        GMLNode start = dEdge.getStartNode();
        GMLNode current = dEdge.getEndNode();
        result.add(dEdge);
        seen.add(dEdge.getEdge());
        while (current != start) {
            GMLDirectedEdge next = this.findNextEdge(current, edges, seen);
            if (next == null) {
                return false;
            }
            current = next.getEndNode();
            seen.add(next.getEdge());
            result.add(next);
        }
        this.editor.getMap().remove((GMLObject)shape);
        shape.reorderEdges(result);
        this.editor.getMap().add((GMLObject)shape);
        return true;
    }

    private boolean checkForDegenerateShape(GMLShape shape) {
        if (shape.getEdges().size() < 3) {
            this.editor.getMap().remove((GMLObject)shape);
            return true;
        }
        return false;
    }

    private boolean checkForDegenerateEdge(GMLEdge edge) {
        if (edge.getStart().equals(edge.getEnd())) {
            HashSet<GMLShape> attached = new HashSet<GMLShape>(this.editor.getMap().getAttachedShapes(edge));
            for (GMLShape shape : attached) {
                this.editor.getMap().remove((GMLObject)shape);
                shape.removeEdge(edge);
                this.editor.getMap().add((GMLObject)shape);
            }
            this.editor.getMap().remove((GMLObject)edge);
            return true;
        }
        return false;
    }

    private boolean isFound(GMLNode node, GMLShape shape, GMLDirectedEdge ignore) {
        for (GMLDirectedEdge edge : shape.getEdges()) {
            if (edge == ignore || !node.equals(edge.getStartNode()) && !node.equals(edge.getEndNode())) continue;
            return true;
        }
        return false;
    }

    private GMLDirectedEdge findNextEdge(GMLNode start, Collection<GMLDirectedEdge> possible, Set<GMLEdge> seen) {
        for (GMLDirectedEdge next : possible) {
            if (next.getStartNode() != start || seen.contains(next.getEdge())) continue;
            return next;
        }
        for (GMLDirectedEdge next : possible) {
            if (next.getEndNode() != start || seen.contains(next.getEdge())) continue;
            next.reverse();
            return next;
        }
        return null;
    }
}

