/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import rescuecore2.messages.Command;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;

public class Timestep {
    private int time;
    private Collection<Command> commands;
    private ChangeSet changes;
    private Map<EntityID, ChangeSet> agentPerception;
    private Map<EntityID, Collection<Command>> agentHearing;
    private double score;

    public Timestep(int time) {
        this.time = time;
        this.agentPerception = new HashMap<EntityID, ChangeSet>();
        this.agentHearing = new HashMap<EntityID, Collection<Command>>();
        this.commands = new ArrayList<Command>();
    }

    public void setCommands(Collection<Command> c) {
        this.commands.clear();
        this.commands.addAll(c);
    }

    public void setChangeSet(ChangeSet c) {
        this.changes = c;
    }

    public void registerPerception(EntityID id, ChangeSet perception, Collection<Command> hearing) {
        this.agentPerception.put(id, perception);
        this.agentHearing.put(id, hearing);
    }

    public void setScore(double s) {
        this.score = s;
    }

    public int getTime() {
        return this.time;
    }

    public Collection<Command> getCommands() {
        return Collections.unmodifiableCollection(this.commands);
    }

    public Collection<Command> getCommands(EntityID agentID) {
        HashSet<Command> result = new HashSet<Command>();
        for (Command next : this.commands) {
            if (!next.getAgentID().equals(agentID)) continue;
            result.add(next);
        }
        return result;
    }

    public ChangeSet getChangeSet() {
        return this.changes;
    }

    public Set<EntityID> getAgentsWithUpdates() {
        HashSet<EntityID> result = new HashSet<EntityID>();
        result.addAll(this.agentPerception.keySet());
        result.addAll(this.agentHearing.keySet());
        return result;
    }

    public ChangeSet getAgentPerception(EntityID agentID) {
        return this.agentPerception.get(agentID);
    }

    public Collection<Command> getAgentHearing(EntityID agentID) {
        return this.agentHearing.get(agentID);
    }

    public double getScore() {
        return this.score;
    }
}

