/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import rescuecore2.config.AbstractValueConstraint;
import rescuecore2.config.Config;

public class DiscreteValueConstraint
extends AbstractValueConstraint {
    private Set<String> allowed;

    public DiscreteValueConstraint(String key, Set<String> allowed) {
        super(key);
        this.allowed = new HashSet<String>(allowed);
    }

    @Override
    public String getDescription() {
        StringBuilder result = new StringBuilder();
        result.append("Must be one of: ");
        Iterator<String> it = this.allowed.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    @Override
    public boolean isValid(String value, Config config) {
        return this.allowed.contains(value);
    }
}

