/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.connection;

import java.util.ArrayDeque;
import java.util.Deque;
import rescuecore2.connection.Connection;
import rescuecore2.connection.ConnectionListener;
import rescuecore2.messages.Message;

public class MessageQueueConnectionListener
implements ConnectionListener {
    private Deque<Message> messages = new ArrayDeque<Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Connection c, Message msg) {
        Deque<Message> deque = this.messages;
        synchronized (deque) {
            this.messages.addLast(msg);
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message waitForMessage() throws InterruptedException {
        Deque<Message> deque = this.messages;
        synchronized (deque) {
            while (this.messages.isEmpty()) {
                this.messages.wait();
            }
            return this.messages.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message waitForMessage(long timeout) throws InterruptedException {
        Deque<Message> deque = this.messages;
        synchronized (deque) {
            long end = System.currentTimeMillis() + timeout;
            while (this.messages.isEmpty()) {
                long now = System.currentTimeMillis();
                if (now >= end) {
                    return null;
                }
                this.messages.wait(end - now);
            }
            return this.messages.removeFirst();
        }
    }
}

