/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private int count;
    private InputStream downstream;

    public CountingInputStream(InputStream downstream) {
        this.downstream = downstream;
        this.count = 0;
    }

    @Override
    public int read() throws IOException {
        int result = this.downstream.read();
        ++this.count;
        return result;
    }

    public String toString() {
        return this.downstream + " at position " + this.count;
    }

    public int getByteCount() {
        return this.count;
    }
}

