/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import rescuecore2.registry.PropertyFactory;
import rescuecore2.worldmodel.Property;

public abstract class AbstractPropertyFactory<T extends Enum<T>>
implements PropertyFactory {
    private Class<T> clazz;
    private Method fromString;

    protected AbstractPropertyFactory(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.fromString = clazz.getDeclaredMethod("fromString", String.class);
        }
        catch (NoSuchMethodException e) {
            this.fromString = null;
        }
    }

    @Override
    public String[] getKnownPropertyURNs() {
        EnumSet<T> set = this.getKnownPropertyURNsEnum();
        String[] result = new String[set.size()];
        int i = 0;
        for (Enum next : set) {
            result[i++] = next.toString();
        }
        return result;
    }

    @Override
    public Property makeProperty(String urn) {
        Enum t = null;
        if (this.fromString != null) {
            try {
                t = (Enum)this.fromString.invoke(null, urn);
            }
            catch (IllegalAccessException e) {
                t = null;
            }
            catch (InvocationTargetException e) {
                t = null;
            }
        }
        if (t == null) {
            t = (Enum)Enum.valueOf(this.clazz, urn);
        }
        return this.makeProperty(t);
    }

    protected EnumSet<T> getKnownPropertyURNsEnum() {
        return EnumSet.allOf(this.clazz);
    }

    protected abstract Property makeProperty(T var1);
}

