/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.kernel.comms;

import java.util.Collection;
import java.util.Map;
import kernel.AbstractCommunicationModel;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.collections.LazyMap;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.FireStation;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.PoliceOffice;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.standard.kernel.comms.InvalidMessageException;
import rescuecore2.standard.messages.AKSay;
import rescuecore2.standard.messages.AKTell;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;
import rescuecore2.worldmodel.WorldModel;

public class StandardCommunicationModel
extends AbstractCommunicationModel {
    private static final String SAY_RANGE_KEY = "comms.standard.say.range";
    private static final String PLATOON_MAX_KEY = "comms.standard.platoon.max";
    private static final String MAX_SIZE_KEY = "comms.standard.size.max";
    private StandardWorldModel world;
    private int sayDistance;
    private int maxSize;
    private int platoonMax;
    private int fsMax;
    private int poMax;
    private int acMax;
    private Map<EntityID, Integer> uttered = new LazyMap<EntityID, Integer>(){

        public Integer createValue() {
            return 0;
        }
    };
    private Map<EntityID, Integer> heard = new LazyMap<EntityID, Integer>(){

        public Integer createValue() {
            return 0;
        }
    };

    public String toString() {
        return "Standard communication model";
    }

    public void initialise(Config config, WorldModel<? extends Entity> model) {
        super.initialise(config, model);
        this.world = StandardWorldModel.createStandardWorldModel(model);
        this.sayDistance = config.getIntValue(SAY_RANGE_KEY);
        this.maxSize = config.getIntValue(MAX_SIZE_KEY);
        this.platoonMax = config.getIntValue(PLATOON_MAX_KEY);
        this.fsMax = this.world.getEntitiesOfType(StandardEntityURN.FIRE_BRIGADE).size() * 2;
        this.acMax = this.world.getEntitiesOfType(StandardEntityURN.AMBULANCE_TEAM).size() * 2;
        this.poMax = this.world.getEntitiesOfType(StandardEntityURN.POLICE_FORCE).size() * 2;
    }

    public void process(int time, Collection<? extends Command> agentCommands) {
        super.process(time, agentCommands);
        this.uttered.clear();
        this.heard.clear();
        for (Command command : agentCommands) {
            try {
                if (command instanceof AKSay) {
                    this.processSay((AKSay)command);
                }
                if (!(command instanceof AKTell)) continue;
                this.processTell((AKTell)command);
            }
            catch (InvalidMessageException e) {
                Logger.warn((String)("Invalid message: " + command), (Throwable)e);
            }
        }
    }

    private void processSay(AKSay say) throws InvalidMessageException {
        EntityID senderID = say.getAgentID();
        StandardEntity sender = (StandardEntity)this.world.getEntity(senderID);
        if (!(sender instanceof Human)) {
            throw new InvalidMessageException("Agent " + senderID + " is not a human: " + (sender == null ? "null" : ((Object)((Object)sender)).getClass().getName()));
        }
        byte[] data = say.getContent();
        if (data.length > this.maxSize) {
            throw new InvalidMessageException("Agent " + senderID + " sent an oversize message: " + data.length + " > " + this.maxSize);
        }
        int count = this.uttered.get(senderID);
        int max = this.getMessageMax(sender);
        if (count >= this.getMessageMax(sender)) {
            throw new InvalidMessageException("Agent " + senderID + " has uttered too many messages: " + count + " >= " + max);
        }
        this.uttered.put(senderID, count + 1);
        for (StandardEntity receiver : this.world.getEntitiesOfType(StandardEntityURN.CIVILIAN, StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.FIRE_STATION, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.POLICE_OFFICE)) {
            int distance;
            int h = this.heard.get(receiver.getID());
            if (h >= this.getMessageMax(receiver) || (distance = this.world.getDistance(sender, receiver)) > this.sayDistance) continue;
            this.addHearing((Entity)receiver, new Command[]{say});
            this.heard.put(receiver.getID(), h + 1);
        }
    }

    private void processTell(AKTell tell) throws InvalidMessageException {
        EntityID senderID = tell.getAgentID();
        StandardEntity sender = (StandardEntity)this.world.getEntity(senderID);
        if (!(sender instanceof Human)) {
            throw new InvalidMessageException("Agent " + senderID + " is not a human: " + (sender == null ? "null" : ((Object)((Object)sender)).getClass().getName()));
        }
        byte[] data = tell.getContent();
        if (data.length > this.maxSize) {
            throw new InvalidMessageException("Agent " + senderID + " sent an oversize message: " + data.length + " > " + this.maxSize);
        }
        int count = this.uttered.get(senderID);
        int max = this.getMessageMax(sender);
        if (count >= this.getMessageMax(sender)) {
            throw new InvalidMessageException("Agent " + senderID + " has uttered too many messages: " + count + " >= " + max);
        }
        this.uttered.put(senderID, count + 1);
        for (StandardEntity receiver : this.world.getEntitiesOfType(StandardEntityURN.CIVILIAN, StandardEntityURN.FIRE_BRIGADE, StandardEntityURN.FIRE_STATION, StandardEntityURN.AMBULANCE_TEAM, StandardEntityURN.AMBULANCE_CENTRE, StandardEntityURN.POLICE_FORCE, StandardEntityURN.POLICE_OFFICE)) {
            int h = this.heard.get(receiver.getID());
            if (h >= this.getMessageMax(receiver) || !this.canHear(receiver, sender)) continue;
            this.addHearing((Entity)receiver, new Command[]{tell});
            this.heard.put(receiver.getID(), h + 1);
        }
    }

    private int getMessageMax(StandardEntity e) {
        if (e instanceof FireStation) {
            return this.fsMax;
        }
        if (e instanceof PoliceOffice) {
            return this.poMax;
        }
        if (e instanceof AmbulanceCentre) {
            return this.acMax;
        }
        if (e instanceof Human) {
            return this.platoonMax;
        }
        return 0;
    }

    private boolean canHear(StandardEntity receiver, StandardEntity sender) {
        if (receiver instanceof FireBrigade) {
            return sender instanceof FireBrigade || sender instanceof FireStation;
        }
        if (receiver instanceof FireStation) {
            return sender instanceof FireBrigade || sender instanceof FireStation || sender instanceof PoliceOffice || sender instanceof AmbulanceCentre;
        }
        if (receiver instanceof PoliceForce) {
            return sender instanceof PoliceForce || sender instanceof PoliceOffice;
        }
        if (receiver instanceof PoliceOffice) {
            return sender instanceof PoliceForce || sender instanceof FireStation || sender instanceof PoliceOffice || sender instanceof AmbulanceCentre;
        }
        if (receiver instanceof AmbulanceTeam) {
            return sender instanceof AmbulanceTeam || sender instanceof AmbulanceCentre;
        }
        if (receiver instanceof AmbulanceCentre) {
            return sender instanceof AmbulanceTeam || sender instanceof FireStation || sender instanceof PoliceOffice || sender instanceof AmbulanceCentre;
        }
        return false;
    }
}

