/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.standard.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import rescuecore2.standard.view.AnimatedHumanLayer;
import rescuecore2.standard.view.AreaNeighboursLayer;
import rescuecore2.standard.view.BuildingIconLayer;
import rescuecore2.standard.view.BuildingLayer;
import rescuecore2.standard.view.CommandLayer;
import rescuecore2.standard.view.PositionHistoryLayer;
import rescuecore2.standard.view.RoadBlockageLayer;
import rescuecore2.standard.view.RoadLayer;
import rescuecore2.standard.view.StandardWorldModelViewer;
import rescuecore2.view.ViewLayer;

public class AnimatedWorldModelViewer
extends StandardWorldModelViewer {
    private static final int FRAME_COUNT = 10;
    private static final int ANIMATION_TIME = 750;
    private static final int FRAME_DELAY = 75;
    private AnimatedHumanLayer humans;
    private Timer timer;
    private final Object lock = new Object();
    private boolean done;

    public AnimatedWorldModelViewer() {
        this.timer = new Timer(75, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                Object object = AnimatedWorldModelViewer.this.lock;
                synchronized (object) {
                    if (AnimatedWorldModelViewer.this.done) {
                        return;
                    }
                    AnimatedWorldModelViewer.this.done = true;
                    if (AnimatedWorldModelViewer.this.humans.nextFrame()) {
                        AnimatedWorldModelViewer.this.done = false;
                        AnimatedWorldModelViewer.this.repaint();
                    }
                }
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    @Override
    public String getViewerName() {
        return "Animated world model viewer";
    }

    @Override
    public void addDefaultLayers() {
        this.addLayer((ViewLayer)new BuildingLayer());
        this.addLayer((ViewLayer)new RoadLayer());
        this.addLayer((ViewLayer)new AreaNeighboursLayer());
        this.addLayer((ViewLayer)new RoadBlockageLayer());
        this.addLayer((ViewLayer)new BuildingIconLayer());
        this.humans = new AnimatedHumanLayer();
        this.addLayer((ViewLayer)this.humans);
        CommandLayer commands = new CommandLayer();
        this.addLayer((ViewLayer)commands);
        commands.setRenderMove(false);
        this.addLayer((ViewLayer)new PositionHistoryLayer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void view(Object ... objects) {
        super.view(objects);
        Object object = this.lock;
        synchronized (object) {
            this.done = false;
            this.humans.computeAnimation(10);
        }
    }
}

