/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.geometry.spatialindex;

import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.misc.geometry.spatialindex.PointRegion;
import rescuecore2.misc.geometry.spatialindex.RectangleRegion;
import rescuecore2.misc.geometry.spatialindex.Region;
import rescuecore2.misc.geometry.spatialindex.Tools;

public class LineRegion
implements Region {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private Line2D line;

    public LineRegion(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.line = null;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public Line2D getLine() {
        if (this.line == null) {
            this.line = new Line2D(new Point2D(this.x1, this.y1), new Point2D(this.x2, this.y2));
        }
        return this.line;
    }

    @Override
    public double getXMin() {
        return Math.min(this.x1, this.x2);
    }

    @Override
    public double getYMin() {
        return Math.min(this.y1, this.y2);
    }

    @Override
    public double getXMax() {
        return Math.max(this.x1, this.x2);
    }

    @Override
    public double getYMax() {
        return Math.max(this.y1, this.y2);
    }

    public boolean equals(Object o) {
        if (o instanceof LineRegion) {
            LineRegion l = (LineRegion)o;
            return Tools.equal(this.x1, l.x1) && Tools.equal(this.y1, l.y1) && Tools.equal(this.x2, l.x2) && Tools.equal(this.y2, l.y2);
        }
        return false;
    }

    public int hashCode() {
        Double d = this.x1 + this.x2 + this.y1 + this.y2;
        return d.hashCode();
    }

    public String toString() {
        return "Line region: " + this.x1 + ", " + this.y1 + " -> " + this.x2 + ", " + this.y2;
    }

    @Override
    public boolean intersects(Region r) {
        if (r instanceof RectangleRegion) {
            RectangleRegion rect = (RectangleRegion)r;
            return GeometryTools2D.clipToRectangle(this.getLine(), rect.getXMin(), rect.getYMin(), rect.getXMax(), rect.getYMax()) != null;
        }
        if (r instanceof LineRegion) {
            LineRegion l = (LineRegion)r;
            return GeometryTools2D.getSegmentIntersectionPoint(this.getLine(), l.getLine()) != null;
        }
        if (r instanceof PointRegion) {
            PointRegion p = (PointRegion)r;
            return GeometryTools2D.contains(this.getLine(), p.getPoint());
        }
        return false;
    }

    @Override
    public boolean contains(Region r) {
        if (r instanceof LineRegion) {
            LineRegion l = (LineRegion)r;
            double first = GeometryTools2D.positionOnLine(this.getLine(), l.getLine().getOrigin());
            double second = GeometryTools2D.positionOnLine(this.getLine(), l.getLine().getEndPoint());
            return first >= 0.0 && first <= 1.0 && second >= 0.0 && second <= 1.0;
        }
        if (r instanceof PointRegion) {
            PointRegion p = (PointRegion)r;
            double d = GeometryTools2D.positionOnLine(this.getLine(), p.getPoint());
            return d >= 0.0 && d <= 1.0;
        }
        return false;
    }
}

