/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.misc.gui;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import rescuecore2.misc.gui.ScreenTransform;

public class PanZoomListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private double mouseDownX;
    private double mouseDownY;
    private boolean dragging;
    private ScreenTransform transform;
    private JComponent component;
    private boolean enabled;
    private int panTriggerModifiers;

    public PanZoomListener(JComponent component) {
        this.component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
        this.panTriggerModifiers = 1024;
        this.enabled = true;
    }

    public void setScreenTransform(ScreenTransform t) {
        this.transform = t;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
        if (!this.enabled) {
            this.dragging = false;
        }
    }

    public void setPanTriggerModifiers(int modifiers) {
        this.panTriggerModifiers = modifiers;
        this.dragging = false;
    }

    public void setPanOnLeftMouse() {
        this.setPanTriggerModifiers(1024);
    }

    public void setPanOnRightMouse() {
        this.setPanTriggerModifiers(4096);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (this.transform == null) {
            return;
        }
        if ((e.getModifiersEx() & this.panTriggerModifiers) == this.panTriggerModifiers) {
            Point p = this.fixEventPoint(e.getPoint());
            this.mouseDownX = this.transform.screenToX(p.x);
            this.mouseDownY = this.transform.screenToY(p.y);
            this.dragging = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if ((e.getModifiersEx() & this.panTriggerModifiers) != this.panTriggerModifiers) {
            this.dragging = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.enabled) {
            return;
        }
        if (this.transform == null || !this.dragging) {
            return;
        }
        Point p = this.fixEventPoint(e.getPoint());
        this.transform.makeCentreRelativeTo(this.mouseDownX, this.mouseDownY, p.x, p.y);
        this.component.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double y;
        double x;
        Point p;
        if (!this.enabled) {
            return;
        }
        if (this.transform == null) {
            return;
        }
        if (e.getWheelRotation() < 0) {
            p = this.fixEventPoint(e.getPoint());
            x = this.transform.screenToX(p.x);
            y = this.transform.screenToY(p.y);
            this.transform.zoomIn();
            this.transform.makeCentreRelativeTo(x, y, p.x, p.y);
            this.component.repaint();
        }
        if (e.getWheelRotation() > 0) {
            p = this.fixEventPoint(e.getPoint());
            x = this.transform.screenToX(p.x);
            y = this.transform.screenToY(p.y);
            this.transform.zoomOut();
            this.transform.makeCentreRelativeTo(x, y, p.x, p.y);
            this.component.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private Point fixEventPoint(Point p) {
        Insets insets = this.component.getInsets();
        return new Point(p.x - insets.left, p.y - insets.top);
    }
}

