/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.registry;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EnumSet;
import rescuecore2.messages.Message;
import rescuecore2.registry.MessageFactory;

public abstract class AbstractMessageFactory<T extends Enum<T>>
implements MessageFactory {
    private Class<T> clazz;
    private Method fromString;

    protected AbstractMessageFactory(Class<T> clazz) {
        this.clazz = clazz;
        try {
            this.fromString = clazz.getDeclaredMethod("fromString", String.class);
        }
        catch (NoSuchMethodException e) {
            this.fromString = null;
        }
    }

    @Override
    public String[] getKnownMessageURNs() {
        EnumSet<T> set = this.getKnownMessageURNsEnum();
        String[] result = new String[set.size()];
        int i = 0;
        for (Enum next : set) {
            result[i++] = next.toString();
        }
        return result;
    }

    @Override
    public Message makeMessage(String urn, InputStream data) throws IOException {
        Enum t = null;
        if (this.fromString != null) {
            try {
                t = (Enum)this.fromString.invoke(null, urn);
            }
            catch (IllegalAccessException e) {
                t = null;
            }
            catch (InvocationTargetException e) {
                t = null;
            }
        }
        if (t == null) {
            t = (Enum)Enum.valueOf(this.clazz, urn);
        }
        return this.makeMessage(t, data);
    }

    protected EnumSet<T> getKnownMessageURNsEnum() {
        return EnumSet.allOf(this.clazz);
    }

    protected abstract Message makeMessage(T var1, InputStream var2) throws IOException;
}

