/*
 * Decompiled with CFR 0.152.
 */
package rescuecore2.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import rescuecore2.config.Config;
import rescuecore2.misc.gui.PanZoomListener;
import rescuecore2.misc.gui.ScreenTransform;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewListener;

public abstract class ViewComponent
extends JComponent {
    private static final Color BACKGROUND = new Color(120, 120, 120);
    private PanZoomListener panZoom;
    private ScreenTransform transform;
    private List<RenderedObject> renderedObjects = new ArrayList<RenderedObject>();
    private Set<ViewListener> listeners = new HashSet<ViewListener>();

    protected ViewComponent() {
        ViewerMouseListener l = new ViewerMouseListener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
        this.panZoom = new PanZoomListener(this);
        this.setBackground(BACKGROUND);
        this.setOpaque(true);
    }

    public void initialise(Config config) {
    }

    public String getViewerName() {
        return this.toString();
    }

    public void disablePanZoom() {
        this.removeMouseListener(this.panZoom);
        this.removeMouseMotionListener(this.panZoom);
        this.removeMouseWheelListener(this.panZoom);
        this.transform.resetZoom();
        this.repaint();
    }

    public void enablePanZoom() {
        this.addMouseListener(this.panZoom);
        this.addMouseMotionListener(this.panZoom);
        this.addMouseWheelListener(this.panZoom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addViewListener(ViewListener l) {
        Set<ViewListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeViewListener(ViewListener l) {
        Set<ViewListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public void view(Object ... objects) {
        this.repaint();
    }

    @Override
    public final void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this.renderedObjects.clear();
        this.transform.rescale(width -= insets.left + insets.right, height -= insets.top + insets.bottom);
        Graphics2D copy = (Graphics2D)g.create(insets.left, insets.top, width, height);
        if (this.isOpaque()) {
            copy.setColor(this.getBackground());
            copy.fillRect(0, 0, width, height);
        }
        this.renderedObjects.addAll(this.render(copy, this.transform, width, height));
    }

    protected abstract Collection<RenderedObject> render(Graphics2D var1, ScreenTransform var2, int var3, int var4);

    protected void updateBounds(double xMin, double yMin, double xMax, double yMax) {
        this.transform = new ScreenTransform(xMin, yMin, xMax, yMax);
        this.panZoom.setScreenTransform(this.transform);
    }

    private List<RenderedObject> getObjectsAtPoint(int x, int y) {
        ArrayList<RenderedObject> result = new ArrayList<RenderedObject>();
        for (RenderedObject next : this.renderedObjects) {
            Shape shape = next.getShape();
            if (shape == null || !shape.contains(x, y)) continue;
            result.add(next);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireObjectsClicked(List<RenderedObject> clicked) {
        ArrayList<ViewListener> all = new ArrayList<ViewListener>();
        Set<ViewListener> set = this.listeners;
        synchronized (set) {
            all.addAll(this.listeners);
        }
        for (ViewListener next : all) {
            next.objectsClicked(this, clicked);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireObjectsRollover(List<RenderedObject> objects) {
        ArrayList<ViewListener> all = new ArrayList<ViewListener>();
        Set<ViewListener> set = this.listeners;
        synchronized (set) {
            all.addAll(this.listeners);
        }
        for (ViewListener next : all) {
            next.objectsRollover(this, objects);
        }
    }

    private class ViewerMouseListener
    implements MouseListener,
    MouseMotionListener {
        private ViewerMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                ViewComponent.this.fireObjectsClicked(this.getObjects(e));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ViewComponent.this.fireObjectsRollover(this.getObjects(e));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        private List<RenderedObject> getObjects(MouseEvent e) {
            Point p = e.getPoint();
            Insets insets = ViewComponent.this.getInsets();
            return ViewComponent.this.getObjectsAtPoint(p.x - insets.left, p.y - insets.top);
        }
    }
}

