/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import rescuecore.InputBuffer;
import rescuecore.OutputBuffer;
import rescuecore.Property;

public class ArrayProperty
extends Property {
    private int[] values;
    private int numValues;

    public ArrayProperty(int type) {
        super(type);
        this.values = new int[10];
        this.numValues = 0;
    }

    public ArrayProperty(int type, int[] values) {
        super(type);
        this.values = new int[values.length];
        this.numValues = values.length;
        System.arraycopy(values, 0, this.values, 0, values.length);
        this.lastUpdate = 0;
    }

    public int[] getValues() {
        int[] result = new int[this.numValues];
        System.arraycopy(this.values, 0, result, 0, this.numValues);
        return result;
    }

    @Override
    public String getStringValue() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < this.numValues; ++i) {
            result.append(this.values[i]);
            if (i >= this.numValues - 1) continue;
            result.append(",");
        }
        result.append("]");
        return result.toString();
    }

    public boolean setValues(int[] newValues, int timestamp, Object source) {
        this.lastUpdate = timestamp;
        this.lastUpdateSource = source;
        if (!this.different(newValues)) {
            return false;
        }
        this.values = new int[newValues.length];
        System.arraycopy(newValues, 0, this.values, 0, this.values.length);
        this.numValues = newValues.length;
        return true;
    }

    public boolean updateValues(int[] newValues, int timestamp, Object source) {
        if (timestamp <= this.lastUpdate) {
            return false;
        }
        if (this.lastUpdate >= 0 && !this.different(newValues)) {
            return false;
        }
        this.lastUpdate = timestamp;
        this.lastUpdateSource = source;
        this.values = new int[newValues.length];
        System.arraycopy(newValues, 0, this.values, 0, this.values.length);
        this.numValues = newValues.length;
        return true;
    }

    public void append(int value) {
        if (this.numValues == this.values.length) {
            int[] newValues = new int[this.values.length + 10];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            this.values = newValues;
        }
        this.values[this.numValues++] = value;
    }

    public void clear() {
        this.numValues = 0;
    }

    @Override
    public boolean merge(Property p) {
        if (p instanceof ArrayProperty) {
            return this.updateValues(((ArrayProperty)p).values, p.lastUpdate, p.lastUpdateSource);
        }
        return false;
    }

    @Override
    public void write(OutputBuffer out) {
        out.writeInt(this.numValues);
        for (int i = 0; i < this.numValues; ++i) {
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public boolean read(InputBuffer in, int timestamp, Object source) {
        int number = in.readInt();
        int[] newValues = new int[number];
        for (int i = 0; i < number; ++i) {
            newValues[i] = in.readInt();
        }
        return this.updateValues(newValues, timestamp, source);
    }

    private boolean different(int[] newValues) {
        return this.different(newValues, newValues.length);
    }

    private boolean different(int[] newValues, int count) {
        if (count != this.numValues) {
            return true;
        }
        for (int i = 0; i < this.numValues && i < count; ++i) {
            if (newValues[i] == this.values[i]) continue;
            return true;
        }
        return false;
    }
}

