/*
 * Decompiled with CFR 0.152.
 */
package rescuecore;

import java.util.Arrays;
import rescuecore.LongUDPFragment;

public class LongUDPMessage {
    public static final int CHUNK_SIZE = 1024;
    private byte[] data;

    public LongUDPMessage(byte[] data) {
        this.data = data;
    }

    public LongUDPFragment[] fragment(short id) {
        int count = 0;
        int done = 0;
        short fragments = (short)(this.data.length / 1024);
        if (this.data.length % 1024 != 0) {
            fragments = (short)(fragments + 1);
        }
        LongUDPFragment[] result = new LongUDPFragment[fragments];
        while (done < this.data.length) {
            byte[] someData = new byte[Math.min(1024, this.data.length - done)];
            System.arraycopy(this.data, done, someData, 0, someData.length);
            result[count] = new LongUDPFragment(id, count, fragments, someData);
            count = (short)(count + 1);
            done += someData.length;
        }
        return result;
    }

    public byte[] getData() {
        return this.data;
    }

    public static LongUDPMessage defragment(LongUDPFragment[] fragments) {
        Arrays.sort(fragments);
        if (!LongUDPMessage.checkFragments(fragments)) {
            return null;
        }
        int totalSize = 0;
        for (int i = 0; i < fragments.length; ++i) {
            totalSize += fragments[i].getData().length;
        }
        byte[] data = new byte[totalSize];
        int offset = 0;
        for (int i = 0; i < fragments.length; ++i) {
            byte[] next = fragments[i].getData();
            System.arraycopy(next, 0, data, offset, next.length);
            offset += next.length;
        }
        return new LongUDPMessage(data);
    }

    private static boolean checkFragments(LongUDPFragment[] fragments) {
        int i;
        int id = fragments[0].getID();
        int total = fragments[0].getTotal();
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i].getID() != id) {
                System.out.println("Fragment " + (i + 1) + " has id " + fragments[i].getID() + " - it should be " + id);
                return false;
            }
            if (fragments[i].getTotal() == total) continue;
            System.out.println("Fragment " + (i + 1) + " thinks there should be " + fragments[i].getTotal() + " fragments in total - it should be " + total);
            return false;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i].getNumber() == i) continue;
            System.out.println("Fragment " + (i + 1) + " thinks it should be number " + (fragments[i].getNumber() + 1));
            return false;
        }
        return true;
    }
}

