/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.debug;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Line2D;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.objects.Building;
import rescuecore.objects.Node;
import rescuecore.objects.Road;
import rescuecore.view.MapRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;

public class OutlineRenderer
implements MapRenderer {
    public static final OutlineRenderer RED = new OutlineRenderer(Color.RED);
    public static final OutlineRenderer GREEN = new OutlineRenderer(Color.GREEN);
    public static final OutlineRenderer BLUE = new OutlineRenderer(Color.BLUE);
    public static final OutlineRenderer ORANGE = new OutlineRenderer(Color.ORANGE);
    public static final OutlineRenderer YELLOW = new OutlineRenderer(Color.YELLOW);
    public static final OutlineRenderer WHITE = new OutlineRenderer(Color.WHITE);
    private Color outline;
    private Color fill;

    private OutlineRenderer(Color outline) {
        this.outline = outline;
        this.fill = new Color(outline.getRed(), outline.getGreen(), outline.getBlue(), 96);
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof RescueObject[] && ((RescueObject[])o).length == 2;
    }

    @Override
    public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
        Building b;
        RescueObject[] rs = (RescueObject[])o;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        if (rs[1].isBuilding()) {
            b = (Building)rs[1];
            Node n = (Node)rs[0];
            x2 = transform.toScreenX(b.getX());
            y2 = transform.toScreenY(b.getY());
            x1 = transform.toScreenX(n.getX());
            y1 = transform.toScreenY(n.getY());
        } else if (rs[0].isBuilding()) {
            b = (Building)rs[0];
            Node n = (Node)rs[1];
            x2 = transform.toScreenX(b.getX());
            y2 = transform.toScreenY(b.getY());
            x1 = transform.toScreenX(n.getX());
            y1 = transform.toScreenY(n.getY());
        } else if (rs[1].isRoad() || rs[0].isRoad()) {
            Road r = rs[0].isRoad() ? (Road)rs[0] : (Road)rs[1];
            Node head = (Node)memory.lookup(r.getHead());
            Node tail = (Node)memory.lookup(r.getTail());
            x2 = transform.toScreenX(head.getX());
            y2 = transform.toScreenY(head.getY());
            x1 = transform.toScreenX(tail.getX());
            y1 = transform.toScreenY(tail.getY());
        } else if (rs[0].isNode() && rs[1].isNode()) {
            Node n1 = (Node)rs[0];
            Node n2 = (Node)rs[1];
            x2 = transform.toScreenX(n1.getX());
            y2 = transform.toScreenY(n1.getY());
            x1 = transform.toScreenX(n2.getX());
            y1 = transform.toScreenY(n2.getY());
        } else {
            return new Polygon(new int[0], new int[0], 0);
        }
        Shape shape = new Line2D.Double(x1, y1, x2, y2);
        shape = new BasicStroke(6.0f).createStrokedShape(shape);
        RenderTools.setFillMode(g, 0, this.fill);
        ((Graphics2D)g).fill(shape);
        return shape;
    }
}

