/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.objects;

import rescuecore.ArrayProperty;
import rescuecore.IntProperty;
import rescuecore.Property;
import rescuecore.objects.RealObject;

public abstract class MovingObject
extends RealObject {
    protected IntProperty position;
    protected IntProperty positionExtra;
    protected IntProperty direction;
    protected ArrayProperty positionHistory;

    protected MovingObject() {
        this.position = new IntProperty(38);
        this.positionExtra = new IntProperty(39);
        this.direction = new IntProperty(40);
        this.positionHistory = new ArrayProperty(41);
    }

    protected MovingObject(int pos, int extra, int dir, int[] history) {
        this.position = new IntProperty(38, pos);
        this.positionExtra = new IntProperty(39, extra);
        this.direction = new IntProperty(40, dir);
        this.positionHistory = new ArrayProperty(41, history);
    }

    @Override
    public Property getProperty(int property) {
        switch (property) {
            case 38: {
                return this.position;
            }
            case 39: {
                return this.positionExtra;
            }
            case 40: {
                return this.direction;
            }
            case 41: {
                return this.positionHistory;
            }
        }
        return super.getProperty(property);
    }

    public int getPosition() {
        return this.position.getValue();
    }

    public boolean setPosition(int p, int timestamp, Object source) {
        if (this.position.updateValue(p, timestamp, source)) {
            this.firePropertyChanged(38, timestamp, source);
            return true;
        }
        return false;
    }

    public int getPositionExtra() {
        return this.positionExtra.getValue();
    }

    public boolean setPositionExtra(int e, int timestamp, Object source) {
        if (this.positionExtra.updateValue(e, timestamp, source)) {
            this.firePropertyChanged(39, timestamp, source);
            return true;
        }
        return false;
    }

    public int getDirection() {
        return this.direction.getValue();
    }

    public boolean setDirection(int d, int timestamp, Object source) {
        if (this.direction.updateValue(d, timestamp, source)) {
            this.firePropertyChanged(40, timestamp, source);
            return true;
        }
        return false;
    }

    public int[] getPositionHistory() {
        return this.positionHistory.getValues();
    }

    public boolean setPositionHistory(int[] h, int timestamp, Object source) {
        if (this.positionHistory.updateValues(h, timestamp, source)) {
            this.firePropertyChanged(41, timestamp, source);
            return true;
        }
        return false;
    }

    public void clearPositionHistory(int timestamp, Object source) {
        this.positionHistory.clear();
        this.firePropertyChanged(41, timestamp, source);
    }

    public void appendPositionHistory(int next, int timestamp, Object source) {
        this.positionHistory.append(next);
        this.firePropertyChanged(41, timestamp, source);
    }
}

