/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.log.Log;
import rescuecore.objects.Road;
import rescuecore.view.Map;
import rescuecore.view.ObjectInspector;
import rescuecore.view.ObjectSelector;

public class LogViewer
extends JPanel {
    private ObjectInspector inspector;
    private Map map;
    private Log log;
    private int time;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: LogViewer <filename>");
            return;
        }
        try {
            Log log = Log.generateLog(args[0]);
            JFrame frame = new JFrame("Log viewer");
            frame.setContentPane(new LogViewer(log));
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.pack();
            Toolkit t = Toolkit.getDefaultToolkit();
            Dimension d = t.getScreenSize();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LogViewer(Log log) {
        super(new BorderLayout());
        this.log = log;
        this.time = 0;
        this.map = Map.defaultMap(log.getMemory(0));
        final JSlider slider = new JSlider(0, log.getMaxTimestep());
        this.add((Component)this.map, "Center");
        JPanel timePanel = new JPanel(new BorderLayout());
        Border b = BorderFactory.createLineBorder(Color.BLACK);
        b = BorderFactory.createTitledBorder(b, "Time Step");
        timePanel.setBorder(b);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.setSnapToTicks(true);
        slider.setMinorTickSpacing(1);
        slider.setMajorTickSpacing(10);
        JButton left = new JButton(" < ");
        JButton right = new JButton(" > ");
        left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                slider.setValue(slider.getValue() - 1);
            }
        });
        right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                slider.setValue(slider.getValue() + 1);
            }
        });
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!slider.getValueIsAdjusting()) {
                    LogViewer.this.setTimeStep(slider.getValue());
                }
            }
        });
        timePanel.add((Component)slider, "Center");
        timePanel.add((Component)left, "West");
        timePanel.add((Component)right, "East");
        this.add((Component)timePanel, "South");
        this.inspector = new ObjectInspector();
        this.add((Component)this.inspector, "East");
        ObjectSelector selector = new ObjectSelector(this.map);
        selector.addObjectSelectionListener(this.inspector);
        slider.setValue(0);
    }

    private void setTimeStep(int t) {
        if (t < 0 || t > this.log.getMaxTimestep()) {
            return;
        }
        this.time = t;
        Memory m = this.log.getMemory(this.time);
        this.map.setMemory(m);
        this.map.repaint();
        Collection<RescueObject> all = m.getAllObjects();
        for (RescueObject next : all) {
            if (!(next instanceof Road)) continue;
            Road r = (Road)next;
            if (r.getBlock() > r.getWidth()) {
                System.out.println("Overblocked");
            }
            if (r.getLinesToHead() == r.getLinesToTail()) continue;
            System.out.println("Asymmetric road");
        }
    }

    private void moveTime(int delta) {
        this.setTimeStep(this.time + delta);
    }
}

