/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import rescuecore.CannotFindLocationException;
import rescuecore.HashMemory;
import rescuecore.Memory;
import rescuecore.objects.Node;
import rescuecore.objects.Road;
import rescuecore.tools.MapFiles;
import rescuecore.view.Layer;
import rescuecore.view.Map;
import rescuecore.view.MapRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;

public class PlaceBlockages {
    private Road[] allRoads;
    private Node[] allNodes;
    private Memory memory;
    private Map map;
    private Point pressPoint;
    private Point dragPoint;
    private Layer overlay;
    private Layer roadLayer;

    public PlaceBlockages(Road[] roads, Node[] nodes) {
        int i;
        this.allRoads = roads;
        this.allNodes = nodes;
        this.memory = new HashMemory();
        for (i = 0; i < roads.length; ++i) {
            this.memory.add(roads[i], 0, this);
        }
        for (i = 0; i < nodes.length; ++i) {
            if (this.memory.lookup(nodes[i].getID()) != null) {
                System.err.println("WARNING: Duplicate node ID: " + nodes[i].getID() + ", this is is already used by " + this.memory.lookup(nodes[i].getID()));
            }
            this.memory.add(nodes[i], 0, this);
        }
        Arrays.sort(this.allRoads, new RoadSorter(this.memory));
        this.map = new Map(this.memory);
        this.roadLayer = Layer.createRoadLayer(this.memory);
        this.roadLayer.addRenderer(Road.class, new BigRoadRenderer());
        this.map.addLayer(this.roadLayer);
        this.map.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PlaceBlockages.this.handleClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PlaceBlockages.this.handlePress(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PlaceBlockages.this.handleRelease(e);
            }
        });
        this.map.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PlaceBlockages.this.handleDrag(e);
            }
        });
        JToolBar toolbar = new JToolBar();
        AbstractAction saveAction = new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaceBlockages.this.save();
            }
        };
        toolbar.add(saveAction);
        JFrame frame = new JFrame("Road Blockage Placement");
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)toolbar, "North");
        top.add((Component)this.map, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(top);
        frame.pack();
        frame.setVisible(true);
    }

    private void handleClick(MouseEvent e) {
        Object[] all = this.map.getObjectsAtPoint(e.getPoint());
        this.update(all);
        this.map.repaint();
    }

    private void handlePress(MouseEvent e) {
        this.pressPoint = e.getPoint();
    }

    private void handleRelease(MouseEvent e) {
        if (this.dragPoint == null) {
            return;
        }
        int x1 = Math.min(this.pressPoint.x, this.dragPoint.x);
        int y1 = Math.min(this.pressPoint.y, this.dragPoint.y);
        int x2 = Math.max(this.pressPoint.x, this.dragPoint.x);
        int y2 = Math.max(this.pressPoint.y, this.dragPoint.y);
        Rectangle2D.Double box = new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        Object[] objects = this.map.getObjectsInArea(box);
        this.update(objects);
        this.pressPoint = null;
        this.dragPoint = null;
        this.overlay.removeAllObjects();
        this.map.repaint();
    }

    private void handleDrag(MouseEvent e) {
        if (this.pressPoint != null) {
            this.dragPoint = e.getPoint();
            int dx = this.pressPoint.x - this.dragPoint.x;
            int dy = this.pressPoint.y - this.dragPoint.y;
            if (dx < 0) {
                dx = -dx;
            }
            if (dy < 0) {
                dy = -dy;
            }
            if (dx > 5 || dy > 5) {
                Rectangle r = new Rectangle(Math.min(this.pressPoint.x, this.dragPoint.x), Math.min(this.pressPoint.y, this.dragPoint.y), dx, dy);
                this.overlay.setObject(r);
                this.map.repaint();
            }
        }
    }

    private void update(Object[] os) {
        for (int i = 0; i < os.length; ++i) {
            if (!(os[i] instanceof Road)) continue;
            this.updateRoad((Road)os[i]);
        }
        this.map.repaint();
    }

    private void updateRoad(Road road) {
        int laneWidth;
        int blocked;
        int blockNeeded;
        int lanes;
        int empty = lanes = road.getLinesToHead();
        int width = road.getWidth();
        if (--empty == -1) {
            empty = lanes;
        }
        if ((blockNeeded = (blocked = lanes - empty) * (laneWidth = road.getWidth() / (road.getLinesToHead() + road.getLinesToTail())) * 2) > road.getWidth()) {
            System.out.println("Trying to set block to " + blockNeeded + " but width is only " + road.getWidth());
            blockNeeded = road.getWidth();
        }
        road.setBlock(blockNeeded, 0, this);
        int free = road.getLinesToHead();
        if (free != empty) {
            System.out.println("We have " + free + " empty lanes instead of " + empty + "!");
        }
    }

    private void save() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(new File("blockades.lst")));
            for (int i = 0; i < this.allRoads.length; ++i) {
                out.println(this.allRoads[i].getBlock());
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            Road[] r = MapFiles.loadRoads("road.bin");
            Node[] n = MapFiles.loadNodes("node.bin");
            new PlaceBlockages(r, n);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class RoadSorter
    implements Comparator {
        private Memory m;

        public RoadSorter(Memory m) {
            this.m = m;
        }

        public int compare(Object o1, Object o2) {
            Road r1 = (Road)o1;
            Road r2 = (Road)o2;
            Node h1 = (Node)this.m.lookup(r1.getHead());
            Node t1 = (Node)this.m.lookup(r1.getTail());
            Node h2 = (Node)this.m.lookup(r2.getHead());
            Node t2 = (Node)this.m.lookup(r2.getTail());
            int x1 = (h1.getX() + t1.getX()) / 2;
            int y1 = (h1.getY() + t1.getY()) / 2;
            int x2 = (h2.getX() + t2.getX()) / 2;
            int y2 = (h2.getY() + t2.getY()) / 2;
            if (x1 < x2) {
                return -1;
            }
            if (x1 > x2) {
                return 1;
            }
            if (y1 < y2) {
                return -1;
            }
            if (y2 > y1) {
                return 1;
            }
            return 0;
        }
    }

    private static class BigRoadRenderer
    implements MapRenderer {
        private BigRoadRenderer() {
        }

        @Override
        public boolean canRender(Object o) {
            return o instanceof Road;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) throws CannotFindLocationException {
            int lanes;
            Road road = (Road)o;
            Node roadHead = (Node)memory.lookup(road.getHead());
            Node roadTail = (Node)memory.lookup(road.getTail());
            int headX = transform.toScreenX(roadHead.getX());
            int headY = transform.toScreenY(roadHead.getY());
            int tailX = transform.toScreenX(roadTail.getX());
            int tailY = transform.toScreenY(roadTail.getY());
            Shape shape = new Line2D.Double(headX, headY, tailX, tailY);
            shape = new BasicStroke(10.0f).createStrokedShape(shape);
            Color c = Color.BLACK;
            int free = lanes = road.getLinesToHead();
            c = Color.ORANGE;
            if (free == 0) {
                c = Color.BLACK;
            }
            if (free == lanes) {
                c = Color.WHITE;
            }
            RenderTools.setLineMode(g, 0, c);
            ((Graphics2D)g).draw(shape);
            return shape;
        }
    }
}

