/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.log.InvalidLogException;
import rescuecore.log.Log;
import rescuecore.objects.Building;
import rescuecore.objects.Humanoid;
import rescuecore.objects.RealObject;

public class Score {
    private static final String HEADER = "RoboCup-Rescue Prototype Log 00\u0000";
    private static final String SILENT_FLAG = "--silent";
    private static final String JUST_SCORE_FLAG = "--just-score";
    private static final String KILL_FLAG = "--no-kill-civilians";
    private static boolean silent;
    private static boolean justScore;
    private static boolean killCiviliansAtEnd;
    private static final int VERBOSITY_NONE = 0;
    private static final int VERBOSITY_SOME = 1;
    private static final int VERBOSITY_LOTS = 2;
    private static final int MODE_MAXIMUM = 0;
    private static final int MODE_MINIMUM = 1;
    private static final int MODE_AVERAGE = 2;
    private static final int MODE_VARIANCE = 3;
    private static final int MODE_STANDARD_DEVIATION = 4;

    public static void main(String[] args) {
        silent = false;
        justScore = false;
        killCiviliansAtEnd = true;
        if (args.length == 0) {
            Score.printUsage();
            return;
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(SILENT_FLAG)) {
                silent = true;
                continue;
            }
            if (args[i].equalsIgnoreCase(JUST_SCORE_FLAG)) {
                justScore = true;
                continue;
            }
            if (args[i].equalsIgnoreCase(KILL_FLAG)) {
                killCiviliansAtEnd = false;
                continue;
            }
            fileNames.add(args[i]);
        }
        if (fileNames.size() == 0) {
            Score.printUsage();
            return;
        }
        ArrayList<LogScore> allScores = new ArrayList<LogScore>();
        for (String next : fileNames) {
            try {
                LogScore score;
                if (!silent) {
                    System.err.println("Reading log " + next);
                }
                if ((score = Score.calculateScore(next)) == null) continue;
                allScores.add(score);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LogScore[] scores = new LogScore[allScores.size()];
        allScores.toArray(scores);
        if (justScore || scores.length == 1) {
            for (int i = 0; i < scores.length; ++i) {
                System.out.println(scores[i].score);
            }
        } else {
            LogScore max = new LogScore("Highest", scores, 0);
            LogScore min = new LogScore("Lowest", scores, 1);
            LogScore average = new LogScore("Average", scores, 2);
            LogScore variance = new LogScore("Variance", scores, 3);
            LogScore sd = new LogScore("Standard deviation", scores, 4);
            System.out.println("Run\tBuilding area left\tBuilding area total\tHP left\tHP total\tCivilians alive\tTotal civilians\tAgents alive\tTotal agents\tScore from HP\tScore from buildings\tOverall score");
            for (int i = 0; i < scores.length; ++i) {
                scores[i].write();
            }
            System.out.println();
            if (scores.length > 1) {
                System.out.println("\tBuilding area left\tBuilding area total\tHP left\tHP total\tCivilians alive\tTotal civilians\tAgents alive\tTotal agents\tScore from HP\tScore from buildings\tOverall score");
                max.write();
                min.write();
                average.write();
                variance.write();
                sd.write();
            }
        }
    }

    private static LogScore calculateScore(String filename) throws IOException, InvalidLogException {
        Log log = Log.generateLog(filename);
        return new LogScore(filename, log.getMemory(log.getMaxTimestep()), killCiviliansAtEnd);
    }

    private static void printUsage() {
        System.out.println("Usage: Score [options] <log files>");
        System.out.println("Options");
        System.out.println("=======");
        System.out.println("--silent\tSilent mode. No progress indicators will be emitted.");
        System.out.println("--just-score\tDon't calculate any statistics about the scores.");
        System.out.println("--no-kill-civilians\tDon't consider buried or damaged civilians to be dead.");
    }

    private static double calculate(double[] values, int mode) {
        switch (mode) {
            case 0: {
                double result = values[0];
                for (int i = 0; i < values.length; ++i) {
                    result = Math.max(result, values[i]);
                }
                return result;
            }
            case 1: {
                double result = values[0];
                for (int i = 0; i < values.length; ++i) {
                    result = Math.min(result, values[i]);
                }
                return result;
            }
            case 2: {
                double result = 0.0;
                for (int i = 0; i < values.length; ++i) {
                    result += values[i];
                }
                return result / (double)values.length;
            }
            case 3: {
                int i;
                double average = 0.0;
                for (i = 0; i < values.length; ++i) {
                    average += values[i];
                }
                average /= (double)values.length;
                double result = 0.0;
                for (i = 0; i < values.length; ++i) {
                    result += (values[i] - average) * (values[i] - average);
                }
                return result / (double)(values.length - 1);
            }
            case 4: {
                int i;
                double average = 0.0;
                for (i = 0; i < values.length; ++i) {
                    average += values[i];
                }
                average /= (double)values.length;
                double result = 0.0;
                for (i = 0; i < values.length; ++i) {
                    result += (values[i] - average) * (values[i] - average);
                }
                return Math.sqrt(result / (double)(values.length - 1));
            }
        }
        throw new RuntimeException("Unknown mode: " + mode);
    }

    private static class LogScore {
        String name;
        double score;
        double HPscore;
        double buildingScore;
        double areaMax;
        double areaLeft;
        double hpMax;
        double hpLeft;
        double civilians;
        double civiliansAlive;
        double agents;
        double agentsAlive;

        public LogScore(String name, LogScore[] scores, int mode) {
            this.name = name;
            double[][] values = new double[11][scores.length];
            for (int i = 0; i < scores.length; ++i) {
                values[0][i] = scores[i].score;
                values[1][i] = scores[i].HPscore;
                values[2][i] = scores[i].buildingScore;
                values[3][i] = scores[i].areaMax;
                values[4][i] = scores[i].areaLeft;
                values[5][i] = scores[i].hpMax;
                values[6][i] = scores[i].hpLeft;
                values[7][i] = scores[i].civilians;
                values[8][i] = scores[i].civiliansAlive;
                values[9][i] = scores[i].agents;
                values[10][i] = scores[i].agentsAlive;
            }
            this.score = Score.calculate(values[0], mode);
            this.HPscore = Score.calculate(values[1], mode);
            this.buildingScore = Score.calculate(values[2], mode);
            this.areaMax = Score.calculate(values[3], mode);
            this.areaLeft = Score.calculate(values[4], mode);
            this.hpMax = Score.calculate(values[5], mode);
            this.hpLeft = Score.calculate(values[6], mode);
            this.civilians = Score.calculate(values[7], mode);
            this.civiliansAlive = Score.calculate(values[8], mode);
            this.agents = Score.calculate(values[9], mode);
            this.agentsAlive = Score.calculate(values[10], mode);
        }

        public LogScore(String name, Memory state, boolean killCivilians) {
            RealObject next;
            this.name = name;
            Collection<RescueObject> allBuildings = state.getObjectsOfType(32, 33, 34, 36, 35);
            Collection<RescueObject> allAgents = state.getObjectsOfType(64, 66, 68, 67);
            this.areaMax = 0.0;
            this.areaLeft = 0.0;
            this.hpMax = 0.0;
            this.hpLeft = 0.0;
            this.civilians = 0.0;
            this.civiliansAlive = 0.0;
            this.agents = allAgents.size();
            this.agentsAlive = 0.0;
            for (RescueObject b : allBuildings) {
                next = (Building)b;
                double area = ((Building)next).getTotalArea();
                this.areaMax += area;
                switch (((Building)next).getFieryness()) {
                    case 0: {
                        this.areaLeft += area;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.areaLeft += area * 2.0 / 3.0;
                        break;
                    }
                    case 2: 
                    case 6: {
                        this.areaLeft += area / 3.0;
                    }
                }
            }
            for (RescueObject a : allAgents) {
                next = (Humanoid)a;
                if (killCivilians && next.isCivilian() && (((Humanoid)next).isDamaged() || ((Humanoid)next).isBuried())) {
                    ((Humanoid)next).setHP(0, 3000, null);
                }
                if (((Humanoid)next).isAlive()) {
                    this.agentsAlive += 1.0;
                }
                if (next.isCivilian()) {
                    this.civilians += 1.0;
                    if (((Humanoid)next).isAlive()) {
                        this.civiliansAlive += 1.0;
                    }
                }
                this.hpMax += 10000.0;
                this.hpLeft += (double)((Humanoid)next).getHP();
            }
            this.HPscore = this.agentsAlive + this.hpLeft / this.hpMax;
            this.buildingScore = Math.sqrt(this.areaLeft / this.areaMax);
            this.score = this.HPscore * this.buildingScore;
        }

        public void write() {
            System.out.print(this.name);
            System.out.print("\t");
            System.out.print(this.areaLeft);
            System.out.print("\t");
            System.out.print(this.areaMax);
            System.out.print("\t");
            System.out.print(this.hpLeft);
            System.out.print("\t");
            System.out.print(this.hpMax);
            System.out.print("\t");
            System.out.print(this.civiliansAlive);
            System.out.print("\t");
            System.out.print(this.civilians);
            System.out.print("\t");
            System.out.print(this.agentsAlive);
            System.out.print("\t");
            System.out.print(this.agents);
            System.out.print("\t");
            System.out.print(this.HPscore);
            System.out.print("\t");
            System.out.print(this.buildingScore);
            System.out.print("\t");
            System.out.println(this.score);
        }
    }
}

