/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.plaf.metal.MetalIconFactory;
import rescuecore.Memory;
import rescuecore.RescueObject;
import rescuecore.objects.Building;
import rescuecore.objects.Node;
import rescuecore.objects.RiverNode;
import rescuecore.view.Layer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;
import rescuecore.view.ViewConstants;

public class Map
extends JComponent {
    private Memory memory;
    private Dimension mapSize;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;
    private int xRange;
    private int yRange;
    private List layers = new ArrayList();
    private JPopupMenu menu;

    public static Map defaultMap(Memory m) {
        Map result = new Map(m);
        result.addLayer(Layer.createRoadLayer(m));
        result.addLayer(Layer.createNodeLayer(m));
        result.addLayer(Layer.createBuildingLayer(m));
        result.addLayer(Layer.createHumanoidLayer(m));
        return result;
    }

    public Map(Memory m) {
        this.setDoubleBuffered(true);
        this.setMemory(m);
        this.menu = new JPopupMenu("Layers");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                if (e.getButton() == 3) {
                    Map.this.menu.pack();
                    Map.this.menu.show(Map.this, p.x, p.y);
                }
            }
        });
    }

    public void addLayer(final Layer l) {
        this.layers.add(l);
        AbstractAction action = new AbstractAction(l.isEnabled() ? "Hide " + l.getName() : "Show " + l.getName()){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.setEnabled(!l.isEnabled());
                this.putValue("SmallIcon", l.isEnabled() ? MetalIconFactory.getMenuItemCheckIcon() : null);
                this.putValue("Name", l.isEnabled() ? "Hide " + l.getName() : "Show " + l.getName());
                Map.this.repaint();
            }
        };
        this.menu.add(action);
        this.repaint();
    }

    public void removeLayer(Layer l) {
        int index = this.layers.indexOf(l);
        this.layers.remove(l);
        this.menu.remove(index);
        this.repaint();
    }

    public void setMemory(Memory m) {
        this.memory = m;
        this.minX = 0;
        this.minY = 0;
        this.maxX = 1;
        this.maxY = 1;
        boolean first = true;
        int x = 0;
        int y = 0;
        Collection<RescueObject> all = this.memory.getAllObjects();
        block5: for (RescueObject rescueObject : all) {
            switch (rescueObject.getType()) {
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    x = ((Building)rescueObject).getX();
                    y = ((Building)rescueObject).getY();
                    break;
                }
                case 4: {
                    x = ((Node)rescueObject).getX();
                    y = ((Node)rescueObject).getY();
                    break;
                }
                case 5: {
                    x = ((RiverNode)rescueObject).getX();
                    y = ((RiverNode)rescueObject).getY();
                    break;
                }
                default: {
                    continue block5;
                }
            }
            if (first) {
                this.minX = this.maxX = x;
                this.minY = this.maxY = y;
                first = false;
                continue;
            }
            this.minX = Math.min(this.minX, x);
            this.maxX = Math.max(this.maxX, x);
            this.minY = Math.min(this.minY, y);
            this.maxY = Math.max(this.maxY, y);
        }
        this.maxX += 6000;
        this.maxY += 6000;
        this.minX -= 6000;
        this.minY -= 6000;
        this.xRange = this.maxX - this.minX;
        this.yRange = this.maxY - this.minY;
        this.mapSize = new Dimension(Math.max(200, Math.min(this.xRange, 600)), Math.max(200, Math.min(this.yRange, 600)));
        for (Layer layer : this.layers) {
            layer.memoryChanged(m);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mapSize;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int width = this.getSize().width;
        int height = this.getSize().height;
        RenderTools.setFillMode(graphics, 0, ViewConstants.BACKGROUND_COLOUR);
        graphics.fillRect(0, 0, width, height);
        Graphics2D g = (Graphics2D)graphics;
        ScreenTransform transform = new ScreenTransform(this.minX, this.minY, this.xRange, this.yRange, width, height);
        for (Layer next : this.layers) {
            if (!next.isEnabled()) continue;
            next.paint(g, width, height, transform, this.memory);
        }
    }

    public Object[] getObjectsAtPoint(Point p) {
        ArrayList<Object> all = new ArrayList<Object>();
        Layer[] allLayers = this.layers.toArray(new Layer[0]);
        for (int i = allLayers.length - 1; i >= 0; --i) {
            Layer next = allLayers[i];
            if (!next.isEnabled()) continue;
            Object[] o = next.getObjectsAtPoint(p);
            for (int j = 0; j < o.length; ++j) {
                all.add(o[j]);
            }
        }
        return all.toArray();
    }

    public Object[] getObjectsInArea(Rectangle2D area) {
        ArrayList<Object> all = new ArrayList<Object>();
        Layer[] allLayers = this.layers.toArray(new Layer[0]);
        for (int i = allLayers.length - 1; i >= 0; --i) {
            Layer next = allLayers[i];
            if (!next.isEnabled()) continue;
            Object[] o = next.getObjectsInArea(area);
            for (int j = 0; j < o.length; ++j) {
                all.add(o[j]);
            }
        }
        return all.toArray();
    }
}

