/*
 * Decompiled with CFR 0.152.
 */
package rescuecore.view;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import rescuecore.Memory;
import rescuecore.objects.Node;
import rescuecore.view.MapRenderer;
import rescuecore.view.RenderTools;
import rescuecore.view.ScreenTransform;

public class NodeRenderer
implements MapRenderer {
    private static final NodeRenderer ORDINARY = new NodeRenderer();

    public static NodeRenderer ordinaryNodeRenderer() {
        return ORDINARY;
    }

    public static NodeRenderer outlinedNodeRenderer(int mode, Color colour) {
        return new OutlinedNodeRenderer(mode, colour);
    }

    protected NodeRenderer() {
    }

    @Override
    public boolean canRender(Object o) {
        return o instanceof Node;
    }

    @Override
    public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
        int x = transform.toScreenX(((Node)o).getX());
        int y = transform.toScreenY(((Node)o).getY());
        RenderTools.setFillMode(g, 0, Color.black);
        g.fillRect(x - 1, y - 1, 3, 3);
        return new Rectangle(x - 1, y - 1, 3, 3);
    }

    private static class OutlinedNodeRenderer
    extends NodeRenderer {
        private int mode;
        private Color colour;

        public OutlinedNodeRenderer(int mode, Color colour) {
            this.mode = mode;
            this.colour = colour;
        }

        @Override
        public Shape render(Object o, Memory memory, Graphics g, ScreenTransform transform) {
            int x = transform.toScreenX(((Node)o).getX());
            int y = transform.toScreenY(((Node)o).getY());
            RenderTools.setLineMode(g, this.mode, this.colour);
            g.drawRect(x - 1, y - 1, 3, 3);
            return new Rectangle(x - 1, y - 1, 3, 3);
        }
    }
}

