/*
 * Decompiled with CFR 0.152.
 */
package traffic3.simulator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.worldmodel.EntityID;

public class PathElement {
    private EntityID areaID;
    private Point2D goalPoint;
    private List<Point2D> allPoints;

    public PathElement(EntityID areaID, Point2D goalPoint, Point2D ... wayPoints) {
        this.areaID = areaID;
        this.goalPoint = goalPoint;
        this.allPoints = new ArrayList<Point2D>(Arrays.asList(wayPoints));
        this.allPoints.add(goalPoint);
        Collections.reverse(this.allPoints);
    }

    public String toString() {
        return "Move to area " + this.areaID + ": " + this.allPoints;
    }

    public Point2D getGoal() {
        return this.goalPoint;
    }

    public List<Point2D> getWaypoints() {
        return Collections.unmodifiableList(this.allPoints);
    }

    public void removeWaypoint(Point2D p) {
        this.allPoints.remove(p);
    }
}

