/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.IntProcedure;
import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.Node;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TIntStack;
import java.util.Properties;
import org.apache.log4j.Logger;

public class RTree
implements SpatialIndex {
    private static final Logger log = Logger.getLogger((String)RTree.class.getName());
    private static final Logger deleteLog = Logger.getLogger((String)(RTree.class.getName() + "-delete"));
    private static final String version = "1.0b2p1";
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    int maxNodeEntries;
    int minNodeEntries;
    private TIntObjectHashMap nodeMap = new TIntObjectHashMap();
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private TIntStack parents = new TIntStack();
    private TIntStack parentsEntry = new TIntStack();
    private int treeHeight = 1;
    private int rootNodeId = 0;
    private int size = 0;
    private int highestUsedNodeId = this.rootNodeId;
    private TIntStack deletedNodeIds = new TIntStack();
    private TIntArrayList nearestIds = new TIntArrayList();
    private TIntProcedureVisit visitProc = new TIntProcedureVisit();
    private Rectangle oldRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);

    public void init(Properties props) {
        this.maxNodeEntries = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
        this.minNodeEntries = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
        if (this.maxNodeEntries < 2) {
            log.warn((Object)("Invalid MaxNodeEntries = " + this.maxNodeEntries + " Resetting to default value of " + 10));
            this.maxNodeEntries = 10;
        }
        if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
            log.warn((Object)"MinNodeEntries must be between 1 and MaxNodeEntries / 2");
            this.minNodeEntries = this.maxNodeEntries / 2;
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            this.initialEntryStatus[i] = 1;
        }
        Node root = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, (Object)root);
        log.info((Object)("init()  MaxNodeEntries = " + this.maxNodeEntries + ", MinNodeEntries = " + this.minNodeEntries));
    }

    public void add(Rectangle r, int id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding rectangle " + r + ", id " + id));
        }
        this.add(r.copy(), id, 1);
        ++this.size;
    }

    private void add(Rectangle r, int id, int level) {
        Node n = this.chooseNode(r, level);
        Node newLeaf = null;
        if (n.entryCount < this.maxNodeEntries) {
            n.addEntryNoCopy(r, id);
        } else {
            newLeaf = this.splitNode(n, r, id);
        }
        Node newNode = this.adjustTree(n, newLeaf);
        if (newNode != null) {
            int oldRootNodeId = this.rootNodeId;
            Node oldRoot = this.getNode(oldRootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntry(newNode.mbr, newNode.nodeId);
            root.addEntry(oldRoot.mbr, oldRoot.nodeId);
            this.nodeMap.put(this.rootNodeId, (Object)root);
        }
    }

    public boolean delete(Rectangle r, int id) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                deleteLog.debug((Object)("searching node " + n.nodeId + ", from index " + startIndex));
                boolean contains = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!n.entries[i].contains(r)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    contains = true;
                    break;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1) {
            n.deleteEntry(foundIndex, this.minNodeEntries);
            this.condenseTree(n);
            --this.size;
        }
        Node root = this.getNode(this.rootNodeId);
        while (root.entryCount == 1 && this.treeHeight > 1) {
            root.entryCount = 0;
            this.rootNodeId = root.ids[0];
            --this.treeHeight;
            root = this.getNode(this.rootNodeId);
        }
        return foundIndex != -1;
    }

    public void nearest(Point p, IntProcedure v, float furthestDistance) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.nearest(p, rootNode, furthestDistance);
        this.visitProc.setProcedure(v);
        this.nearestIds.forEach((TIntProcedure)this.visitProc);
        this.nearestIds.clear();
    }

    public void intersects(Rectangle r, IntProcedure v) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.intersects(r, v, rootNode);
    }

    public void contains(Rectangle r, IntProcedure v) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean intersects = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!r.intersects(n.entries[i])) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    intersects = true;
                    break;
                }
                if (intersects) {
                    continue;
                }
            } else {
                for (int i = 0; i < n.entryCount; ++i) {
                    if (!r.contains(n.entries[i])) continue;
                    v.execute(n.ids[i]);
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    public int size() {
        return this.size;
    }

    public Rectangle getBounds() {
        Rectangle bounds = null;
        Node n = this.getNode(this.getRootNodeId());
        if (n != null && n.getMBR() != null) {
            bounds = n.getMBR().copy();
        }
        return bounds;
    }

    public String getVersion() {
        return "RTree-1.0b2p1";
    }

    private int getNextNodeId() {
        int nextNodeId = 0;
        nextNodeId = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : 1 + this.highestUsedNodeId++;
        return nextNodeId;
    }

    public Node getNode(int index) {
        return (Node)this.nodeMap.get(index);
    }

    public int getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public int getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node n, Rectangle newRect, int newId) {
        float initialArea = 0.0f;
        if (log.isDebugEnabled()) {
            Rectangle union = n.mbr.union(newRect);
            initialArea = union.area();
        }
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node newNode = null;
        newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.nodeMap.put(newNode.nodeId, (Object)newNode);
        this.pickSeeds(n, newRect, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            int i;
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                for (i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    n.mbr.add(n.entries[i]);
                    ++n.entryCount;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                for (i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    newNode.addEntryNoCopy(n.entries[i], n.ids[i]);
                    n.entries[i] = null;
                }
                break;
            }
            this.pickNext(n, newNode);
        }
        n.reorganize(this);
        if (log.isDebugEnabled()) {
            float newArea = n.mbr.area() + newNode.mbr.area();
            float percentageIncrease = 100.0f * (newArea - initialArea) / initialArea;
            log.debug((Object)("Node " + n.nodeId + " split. New area increased by " + percentageIncrease + "%"));
        }
        return newNode;
    }

    private void pickSeeds(Node n, Rectangle newRect, int newId, Node newNode) {
        float maxNormalizedSeparation = 0.0f;
        int highestLowIndex = 0;
        int lowestHighIndex = 0;
        n.mbr.add(newRect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("pickSeeds(): NodeId = " + n.nodeId + ", newRect = " + newRect));
        }
        for (int d = 0; d < 2; ++d) {
            float tempHighestLow = newRect.min[d];
            int tempHighestLowIndex = -1;
            float tempLowestHigh = newRect.max[d];
            int tempLowestHighIndex = -1;
            for (int i = 0; i < n.entryCount; ++i) {
                float tempLow = n.entries[i].min[d];
                if (tempLow >= tempHighestLow) {
                    tempHighestLow = tempLow;
                    tempHighestLowIndex = i;
                } else {
                    float tempHigh = n.entries[i].max[d];
                    if (tempHigh <= tempLowestHigh) {
                        tempLowestHigh = tempHigh;
                        tempLowestHighIndex = i;
                    }
                }
                float normalizedSeparation = (tempHighestLow - tempLowestHigh) / (n.mbr.max[d] - n.mbr.min[d]);
                if (normalizedSeparation > 1.0f || normalizedSeparation < -1.0f) {
                    log.error((Object)"Invalid normalized separation");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Entry " + i + ", dimension " + d + ": HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + ")" + ", LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation));
                }
                if (!(normalizedSeparation > maxNormalizedSeparation)) continue;
                maxNormalizedSeparation = normalizedSeparation;
                highestLowIndex = tempHighestLowIndex;
                lowestHighIndex = tempLowestHighIndex;
            }
        }
        if (highestLowIndex == -1) {
            newNode.addEntry(newRect, newId);
        } else {
            newNode.addEntryNoCopy(n.entries[highestLowIndex], n.ids[highestLowIndex]);
            n.entries[highestLowIndex] = null;
            n.entries[highestLowIndex] = newRect;
            n.ids[highestLowIndex] = newId;
        }
        if (lowestHighIndex == -1) {
            lowestHighIndex = highestLowIndex;
        }
        this.entryStatus[lowestHighIndex] = 0;
        n.entryCount = 1;
        n.mbr.set(n.entries[lowestHighIndex].min, n.entries[lowestHighIndex].max);
    }

    private int pickNext(Node n, Node newNode) {
        float maxDifference = Float.NEGATIVE_INFINITY;
        int next = 0;
        boolean nextGroup = false;
        maxDifference = Float.NEGATIVE_INFINITY;
        if (log.isDebugEnabled()) {
            log.debug((Object)"pickNext()");
        }
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            float newNodeIncrease;
            float nIncrease;
            float difference;
            if (this.entryStatus[i] != 1) continue;
            if (n.entries[i] == null) {
                log.error((Object)("Error: Node " + n.nodeId + ", entry " + i + " is null"));
            }
            if ((difference = Math.abs((nIncrease = n.mbr.enlargement(n.entries[i])) - (newNodeIncrease = newNode.mbr.enlargement(n.entries[i])))) > maxDifference) {
                next = i;
                nextGroup = nIncrease < newNodeIncrease ? false : (newNodeIncrease < nIncrease ? true : (n.mbr.area() < newNode.mbr.area() ? false : (newNode.mbr.area() < n.mbr.area() ? true : newNode.entryCount >= this.maxNodeEntries / 2)));
                maxDifference = difference;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Entry " + i + " group0 increase = " + nIncrease + ", group1 increase = " + newNodeIncrease + ", diff = " + difference + ", MaxDiff = " + maxDifference + " (entry " + next + ")"));
        }
        this.entryStatus[next] = 0;
        if (!nextGroup) {
            n.mbr.add(n.entries[next]);
            ++n.entryCount;
        } else {
            newNode.addEntryNoCopy(n.entries[next], n.ids[next]);
            n.entries[next] = null;
        }
        return next;
    }

    private float nearest(Point p, Node n, float nearestDistance) {
        for (int i = 0; i < n.entryCount; ++i) {
            float tempDistance = n.entries[i].distance(p);
            if (n.isLeaf()) {
                if (tempDistance < nearestDistance) {
                    nearestDistance = tempDistance;
                    this.nearestIds.clear();
                }
                if (!(tempDistance <= nearestDistance)) continue;
                this.nearestIds.add(n.ids[i]);
                continue;
            }
            if (!(tempDistance <= nearestDistance)) continue;
            nearestDistance = this.nearest(p, this.getNode(n.ids[i]), nearestDistance);
        }
        return nearestDistance;
    }

    private void intersects(Rectangle r, IntProcedure v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            if (!r.intersects(n.entries[i])) continue;
            if (n.isLeaf()) {
                v.execute(n.ids[i]);
                continue;
            }
            Node childNode = this.getNode(n.ids[i]);
            this.intersects(r, v, childNode);
        }
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        TIntStack eliminatedNodeIds = new TIntStack();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry, this.minNodeEntries);
                eliminatedNodeIds.push(n.nodeId);
            } else if (!n.mbr.equals(parent.entries[parentEntry])) {
                this.oldRectangle.set(parent.entries[parentEntry].min, parent.entries[parentEntry].max);
                parent.entries[parentEntry].set(n.mbr.min, n.mbr.max);
                parent.recalculateMBR(this.oldRectangle);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode(eliminatedNodeIds.pop());
            for (int j = 0; j < e.entryCount; ++j) {
                this.add(e.entries[j], e.ids[j], e.level);
                e.entries[j] = null;
            }
            e.entryCount = 0;
            this.deletedNodeIds.push(e.nodeId);
        }
    }

    private Node chooseNode(Rectangle r, int level) {
        Node n = this.getNode(this.rootNodeId);
        this.parents.clear();
        this.parentsEntry.clear();
        while (true) {
            if (n == null) {
                log.error((Object)("Could not get root node (" + this.rootNodeId + ")"));
            }
            if (n.level == level) {
                return n;
            }
            float leastEnlargement = n.getEntry(0).enlargement(r);
            int index = 0;
            for (int i = 1; i < n.entryCount; ++i) {
                Rectangle tempRectangle = n.getEntry(i);
                float tempEnlargement = tempRectangle.enlargement(r);
                if (!(tempEnlargement < leastEnlargement) && (tempEnlargement != leastEnlargement || !(tempRectangle.area() < n.getEntry(index).area()))) continue;
                index = i;
                leastEnlargement = tempEnlargement;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
    }

    private Node adjustTree(Node n, Node nn) {
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (parent.ids[entry] != n.nodeId) {
                log.error((Object)("Error: entry " + entry + " in node " + parent.nodeId + " should point to node " + n.nodeId + "; actually points to node " + parent.ids[entry]));
            }
            if (!parent.entries[entry].equals(n.mbr)) {
                parent.entries[entry].set(n.mbr.min, n.mbr.max);
                parent.mbr.set(parent.entries[0].min, parent.entries[0].max);
                for (int i = 1; i < parent.entryCount; ++i) {
                    parent.mbr.add(parent.entries[i]);
                }
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntry(nn.mbr, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, nn.mbr.copy(), nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
            parent = null;
            newNode = null;
        }
        return nn;
    }

    private void checkConsistency(int nodeId, int expectedLevel, Rectangle expectedMBR) {
        Rectangle calculatedMBR;
        Node n = this.getNode(nodeId);
        if (n == null) {
            log.error((Object)("Error: Could not read node " + nodeId));
        }
        if (n.level != expectedLevel) {
            log.error((Object)("Error: Node " + nodeId + ", expected level " + expectedLevel + ", actual level " + n.level));
        }
        if (!n.mbr.equals(calculatedMBR = this.calculateMBR(n))) {
            log.error((Object)("Error: Node " + nodeId + ", calculated MBR does not equal stored MBR"));
        }
        if (expectedMBR != null && !n.mbr.equals(expectedMBR)) {
            log.error((Object)("Error: Node " + nodeId + ", expected MBR (from parent) does not equal stored MBR"));
        }
        if (expectedMBR != null && n.mbr.sameObject(expectedMBR)) {
            log.error((Object)("Error: Node " + nodeId + " MBR using same rectangle object as parent's entry"));
        }
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.entries[i] == null) {
                log.error((Object)("Error: Node " + nodeId + ", Entry " + i + " is null"));
            }
            if (n.level <= 1) continue;
            this.checkConsistency(n.ids[i], n.level - 1, n.entries[i]);
        }
    }

    private Rectangle calculateMBR(Node n) {
        Rectangle mbr = new Rectangle(n.entries[0].min, n.entries[0].max);
        for (int i = 1; i < n.entryCount; ++i) {
            mbr.add(n.entries[i]);
        }
        return mbr;
    }

    private class TIntProcedureVisit
    implements TIntProcedure {
        public IntProcedure m_intProcedure = null;

        private TIntProcedureVisit() {
        }

        public void setProcedure(IntProcedure ip) {
            this.m_intProcedure = ip;
        }

        public boolean execute(int i) {
            this.m_intProcedure.execute(i);
            return true;
        }
    }
}

