/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.geometry.GeometryTools2D;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.misc.geometry.Point2D;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Blockade;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.AbstractSampleAgent;

public class SamplePoliceForce
extends AbstractSampleAgent<PoliceForce> {
    private static final String DISTANCE_KEY = "clear.repair.distance";
    private int distance;

    public String toString() {
        return "Sample police force";
    }

    @Override
    protected void postConnect() {
        super.postConnect();
        ((StandardWorldModel)this.model).indexClass(new StandardEntityURN[]{StandardEntityURN.ROAD});
        this.distance = this.config.getIntValue(DISTANCE_KEY);
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        if (time == this.config.getIntValue("kernel.agents.ignoreuntil")) {
            this.sendSubscribe(time, new int[]{1});
        }
        for (Command next : heard) {
            Logger.debug((String)("Heard " + next));
        }
        Blockade target = this.getTargetBlockade();
        if (target != null) {
            Logger.info((String)("Clearing blockade " + target));
            this.sendSpeak(time, 1, ("Clearing " + target).getBytes());
            this.sendClear(time, target.getID());
            return;
        }
        List<EntityID> path = this.search.breadthFirstSearch(((PoliceForce)this.me()).getPosition(), this.getBlockedRoads());
        if (path != null) {
            Logger.info((String)"Moving to target");
            Road r = (Road)((StandardWorldModel)this.model).getEntity(path.get(path.size() - 1));
            Blockade b = this.getTargetBlockade((Area)r, -1);
            this.sendMove(time, path, b.getX(), b.getY());
            Logger.debug((String)("Path: " + path));
            Logger.debug((String)("Target coordinates: " + b.getX() + ", " + b.getY()));
            return;
        }
        Logger.debug((String)"Couldn't plan a path to a blocked road");
        Logger.info((String)"Moving randomly");
        this.sendMove(time, this.randomWalk());
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.POLICE_FORCE);
    }

    private List<EntityID> getBlockedRoads() {
        Collection e = ((StandardWorldModel)this.model).getEntitiesOfType(StandardEntityURN.ROAD);
        ArrayList<EntityID> result = new ArrayList<EntityID>();
        for (StandardEntity next : e) {
            Road r = (Road)next;
            if (!r.isBlockadesDefined() || r.getBlockades().isEmpty()) continue;
            result.add(r.getID());
        }
        return result;
    }

    private Blockade getTargetBlockade() {
        Logger.debug((String)"Looking for target blockade");
        Area location = (Area)this.location();
        Logger.debug((String)"Looking in current location");
        Blockade result = this.getTargetBlockade(location, this.distance);
        if (result != null) {
            return result;
        }
        Logger.debug((String)"Looking in neighbouring locations");
        for (EntityID next : location.getNeighbours()) {
            location = (Area)((StandardWorldModel)this.model).getEntity(next);
            result = this.getTargetBlockade(location, this.distance);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Blockade getTargetBlockade(Area area, int maxDistance) {
        if (area == null || !area.isBlockadesDefined()) {
            return null;
        }
        List ids = area.getBlockades();
        int x = ((PoliceForce)this.me()).getX();
        int y = ((PoliceForce)this.me()).getY();
        for (EntityID next : ids) {
            Blockade b = (Blockade)((StandardWorldModel)this.model).getEntity(next);
            double d = this.findDistanceTo(b, x, y);
            if (maxDistance >= 0 && !(d < (double)maxDistance)) continue;
            return b;
        }
        return null;
    }

    private int findDistanceTo(Blockade b, int x, int y) {
        List lines = GeometryTools2D.pointsToLines((List)GeometryTools2D.vertexArrayToPoints((int[])b.getApexes()), (boolean)true);
        double best = Double.MAX_VALUE;
        Point2D origin = new Point2D((double)x, (double)y);
        for (Line2D next : lines) {
            Point2D closest = GeometryTools2D.getClosestPointOnSegment((Line2D)next, (Point2D)origin);
            double d = GeometryTools2D.getDistance((Point2D)origin, (Point2D)closest);
            if (!(d < best)) continue;
            best = d;
        }
        return (int)best;
    }
}

