/*
 * Decompiled with CFR 0.152.
 */
package gis2;

import gis2.Scenario;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Random;
import maps.MapException;
import maps.MapReader;
import maps.gml.GMLBuilding;
import maps.gml.GMLMap;
import maps.gml.GMLShape;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class RandomScenarioGenerator {
    private static final int DEFAULT_MIN_CIVS = 50;
    private static final int DEFAULT_MAX_CIVS = 200;
    private static final int DEFAULT_MIN_PLATOONS = 0;
    private static final int DEFAULT_MAX_PLATOONS = 30;
    private static final int DEFAULT_MIN_CENTRES = 0;
    private static final int DEFAULT_MAX_CENTRES = 5;
    private static final int DEFAULT_MIN_REFUGES = 0;
    private static final int DEFAULT_MAX_REFUGES = 20;
    private static final int DEFAULT_MIN_FIRES = 1;
    private static final int DEFAULT_MAX_FIRES = 10;
    private int minCivs = 50;
    private int maxCivs = 200;
    private int minFBs = 0;
    private int maxFBs = 30;
    private int minFSs = 0;
    private int maxFSs = 5;
    private int minPOs = 0;
    private int maxPOs = 5;
    private int minPFs = 0;
    private int maxPFs = 30;
    private int minATs = 0;
    private int maxATs = 30;
    private int minACs = 0;
    private int maxACs = 5;
    private int minFires = 1;
    private int maxFires = 10;
    private int minRefuges = 0;
    private int maxRefuges = 20;

    public static void main(String[] args) {
        String dirName = args[0];
        RandomScenarioGenerator generator = new RandomScenarioGenerator();
        for (int i = 1; i < args.length; ++i) {
            int max;
            int min;
            if ("-civ".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setCivilians(min, max);
                continue;
            }
            if ("-fb".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setFireBrigades(min, max);
                continue;
            }
            if ("-fs".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setFireStations(min, max);
                continue;
            }
            if ("-pf".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setPoliceForces(min, max);
                continue;
            }
            if ("-po".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setPoliceOffices(min, max);
                continue;
            }
            if ("-at".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setAmbulanceTeams(min, max);
                continue;
            }
            if ("-ac".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setAmbulanceCentres(min, max);
                continue;
            }
            if ("-refuge".equals(args[i])) {
                min = Integer.parseInt(args[i + 1]);
                max = Integer.parseInt(args[i + 2]);
                i += 2;
                generator.setRefuges(min, max);
                continue;
            }
            if (!"-fire".equals(args[i])) continue;
            min = Integer.parseInt(args[i + 1]);
            max = Integer.parseInt(args[i + 2]);
            i += 2;
            generator.setFires(min, max);
        }
        try {
            File dir = new File(dirName);
            GMLMap map = (GMLMap)MapReader.readMap((File)new File(dir, "map.gml"));
            Scenario s = generator.makeRandomScenario(map, new Random());
            Document doc = DocumentHelper.createDocument();
            s.write(doc);
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(new File(dir, "scenario.gml")), OutputFormat.createPrettyPrint());
            writer.write(doc);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MapException e) {
            e.printStackTrace();
        }
    }

    public void setCivilians(int min, int max) {
        this.minCivs = min;
        this.maxCivs = max;
    }

    public void setFireBrigades(int min, int max) {
        this.minFBs = min;
        this.maxFBs = max;
    }

    public void setFireStations(int min, int max) {
        this.minFSs = min;
        this.maxFSs = max;
    }

    public void setPoliceForces(int min, int max) {
        this.minPFs = min;
        this.maxPFs = max;
    }

    public void setPoliceOffices(int min, int max) {
        this.minPOs = min;
        this.maxPOs = max;
    }

    public void setAmbulanceTeams(int min, int max) {
        this.minATs = min;
        this.maxATs = max;
    }

    public void setAmbulanceCentres(int min, int max) {
        this.minACs = min;
        this.maxACs = max;
    }

    public void setRefuges(int min, int max) {
        this.minRefuges = min;
        this.maxRefuges = max;
    }

    public void setFires(int min, int max) {
        this.minFires = min;
        this.maxFires = max;
    }

    public Scenario makeRandomScenario(GMLMap map, Random random) {
        Scenario result = new Scenario();
        int civ = random.nextInt(this.maxCivs - this.minCivs + 1) + this.minCivs;
        int fb = random.nextInt(this.maxFBs - this.minFBs + 1) + this.minFBs;
        int fs = random.nextInt(this.maxFSs - this.minFSs + 1) + this.minFSs;
        int pf = random.nextInt(this.maxPFs - this.minPFs + 1) + this.minPFs;
        int po = random.nextInt(this.maxPOs - this.minPOs + 1) + this.minPOs;
        int at = random.nextInt(this.maxATs - this.minATs + 1) + this.minATs;
        int ac = random.nextInt(this.maxACs - this.minACs + 1) + this.minACs;
        int fire = random.nextInt(this.maxFires - this.minFires + 1) + this.minFires;
        int refuge = random.nextInt(this.maxRefuges - this.minRefuges + 1) + this.minRefuges;
        ArrayList buildings = new ArrayList(map.getBuildings());
        Collections.shuffle(buildings, random);
        Iterator<GMLBuilding> it = buildings.iterator();
        this.placeRefuges(it, result, refuge);
        this.placeCentres(it, result, fs, po, ac);
        this.placeFires(it, result, fire);
        this.placeAgents(map, result, random, fb, pf, at, civ);
        return result;
    }

    private void placeRefuges(Iterator<GMLBuilding> it, Scenario result, int num) {
        for (int i = 0; i < num; ++i) {
            result.addRefuge(it.next().getID());
        }
    }

    private void placeCentres(Iterator<GMLBuilding> it, Scenario result, int fire, int police, int ambulance) {
        int i;
        for (i = 0; i < fire; ++i) {
            result.addFireStation(it.next().getID());
        }
        for (i = 0; i < police; ++i) {
            result.addPoliceOffice(it.next().getID());
        }
        for (i = 0; i < ambulance; ++i) {
            result.addAmbulanceCentre(it.next().getID());
        }
    }

    private void placeFires(Iterator<GMLBuilding> it, Scenario result, int num) {
        for (int i = 0; i < num; ++i) {
            result.addFire(it.next().getID());
        }
    }

    private void placeAgents(GMLMap map, Scenario result, Random random, int fire, int police, int ambulance, int civ) {
        int id;
        int i;
        ArrayList all = new ArrayList(map.getAllShapes());
        for (i = 0; i < fire; ++i) {
            id = ((GMLShape)all.get(random.nextInt(all.size()))).getID();
            result.addFireBrigade(id);
        }
        for (i = 0; i < police; ++i) {
            id = ((GMLShape)all.get(random.nextInt(all.size()))).getID();
            result.addPoliceForce(id);
        }
        for (i = 0; i < ambulance; ++i) {
            id = ((GMLShape)all.get(random.nextInt(all.size()))).getID();
            result.addAmbulanceTeam(id);
        }
        for (i = 0; i < civ; ++i) {
            id = ((GMLShape)all.get(random.nextInt(all.size()))).getID();
            result.addCivilian(id);
        }
    }
}

