/*
 * Decompiled with CFR 0.152.
 */
package gis2;

import gis2.ScenarioException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.standard.entities.AmbulanceCentre;
import rescuecore2.standard.entities.AmbulanceTeam;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Civilian;
import rescuecore2.standard.entities.FireBrigade;
import rescuecore2.standard.entities.FireStation;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.PoliceOffice;
import rescuecore2.standard.entities.Refuge;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.Entity;
import rescuecore2.worldmodel.EntityID;

public class Scenario {
    private static final int DEFAULT_HP = 10000;
    private static final int DEFAULT_STAMINA = 10000;
    private static final String WATER_QUANTITY_KEY = "fire.tank.maximum";
    private static final String RCR_NAMESPACE_URI = "urn:roborescue:map:scenario";
    private static final Namespace RCR_NAMESPACE = DocumentHelper.createNamespace((String)"rcr", (String)"urn:roborescue:map:scenario");
    private static final QName RCR_ROOT_QNAME = DocumentHelper.createQName((String)"scenario", (Namespace)RCR_NAMESPACE);
    private static final QName ID_QNAME = DocumentHelper.createQName((String)"id", (Namespace)RCR_NAMESPACE);
    private static final QName LOCATION_QNAME = DocumentHelper.createQName((String)"location", (Namespace)RCR_NAMESPACE);
    private static final QName SCENARIO_QNAME = DocumentHelper.createQName((String)"scenario", (Namespace)RCR_NAMESPACE);
    private static final QName REFUGE_QNAME = DocumentHelper.createQName((String)"refuge", (Namespace)RCR_NAMESPACE);
    private static final QName CIV_QNAME = DocumentHelper.createQName((String)"civilian", (Namespace)RCR_NAMESPACE);
    private static final QName FB_QNAME = DocumentHelper.createQName((String)"firebrigade", (Namespace)RCR_NAMESPACE);
    private static final QName AT_QNAME = DocumentHelper.createQName((String)"ambulanceteam", (Namespace)RCR_NAMESPACE);
    private static final QName PF_QNAME = DocumentHelper.createQName((String)"policeforce", (Namespace)RCR_NAMESPACE);
    private static final QName FS_QNAME = DocumentHelper.createQName((String)"firestation", (Namespace)RCR_NAMESPACE);
    private static final QName AC_QNAME = DocumentHelper.createQName((String)"ambulancecentre", (Namespace)RCR_NAMESPACE);
    private static final QName PO_QNAME = DocumentHelper.createQName((String)"policeoffice", (Namespace)RCR_NAMESPACE);
    private static final QName FIRE_QNAME = DocumentHelper.createQName((String)"fire", (Namespace)RCR_NAMESPACE);
    private Set<Integer> refuges = new HashSet<Integer>();
    private Set<Integer> fires = new HashSet<Integer>();
    private Collection<Integer> civLocations = new ArrayList<Integer>();
    private Collection<Integer> fbLocations = new ArrayList<Integer>();
    private Collection<Integer> atLocations;
    private Collection<Integer> pfLocations = new ArrayList<Integer>();
    private Collection<Integer> fsLocations;
    private Collection<Integer> acLocations;
    private Collection<Integer> poLocations;

    public Scenario() {
        this.atLocations = new ArrayList<Integer>();
        this.fsLocations = new ArrayList<Integer>();
        this.poLocations = new ArrayList<Integer>();
        this.acLocations = new ArrayList<Integer>();
    }

    public Scenario(Document doc) throws ScenarioException {
        this();
        this.read(doc);
    }

    public void read(Document doc) throws ScenarioException {
        Element e;
        this.refuges.clear();
        this.fires.clear();
        this.civLocations.clear();
        this.fbLocations.clear();
        this.pfLocations.clear();
        this.atLocations.clear();
        this.fsLocations.clear();
        this.poLocations.clear();
        this.acLocations.clear();
        Element root = doc.getRootElement();
        if (!root.getQName().equals((Object)SCENARIO_QNAME)) {
            throw new ScenarioException("Scenario document has wrong root element: expecting " + SCENARIO_QNAME + "; not " + root.getQName());
        }
        for (Object next : root.elements(REFUGE_QNAME)) {
            e = (Element)next;
            this.refuges.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(CIV_QNAME)) {
            e = (Element)next;
            this.civLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(FB_QNAME)) {
            e = (Element)next;
            this.fbLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(PF_QNAME)) {
            e = (Element)next;
            this.pfLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(AT_QNAME)) {
            e = (Element)next;
            this.atLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(FS_QNAME)) {
            e = (Element)next;
            this.fsLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(PO_QNAME)) {
            e = (Element)next;
            this.poLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(AC_QNAME)) {
            e = (Element)next;
            this.acLocations.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
        for (Object next : root.elements(FIRE_QNAME)) {
            e = (Element)next;
            this.fires.add(Integer.parseInt(e.attributeValue(LOCATION_QNAME)));
        }
    }

    public void write(Document doc) {
        Element root = DocumentHelper.createElement((QName)SCENARIO_QNAME);
        doc.setRootElement(root);
        for (int next : this.refuges) {
            root.addElement(REFUGE_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.fires) {
            root.addElement(FIRE_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.civLocations) {
            root.addElement(CIV_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.fbLocations) {
            root.addElement(FB_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.fsLocations) {
            root.addElement(FS_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.pfLocations) {
            root.addElement(PF_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.poLocations) {
            root.addElement(PO_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.atLocations) {
            root.addElement(AT_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        for (int next : this.acLocations) {
            root.addElement(AC_QNAME).addAttribute(LOCATION_QNAME, String.valueOf(next));
        }
        root.addNamespace("rcr", RCR_NAMESPACE_URI);
    }

    public void apply(StandardWorldModel model, Config config) throws ScenarioException {
        Building b;
        EntityID id;
        Building b2;
        Logger.debug((String)("Creating " + this.refuges.size() + " refuges"));
        for (int next : this.refuges) {
            Logger.debug((String)("Converting building " + next + " to a refuge"));
            b2 = (Building)model.getEntity(new EntityID(next));
            if (b2 == null) {
                throw new ScenarioException("Building " + next + " does not exist");
            }
            Refuge r = new Refuge(b2);
            model.removeEntity((Entity)b2);
            model.addEntity((Entity)r);
            Logger.debug((String)("Converted " + b2 + " into " + r));
        }
        Logger.debug((String)("Igniting " + this.fires.size() + " fires"));
        for (int next : this.fires) {
            Logger.debug((String)("Igniting " + next));
            b2 = (Building)model.getEntity(new EntityID(next));
            if (b2 == null) {
                throw new ScenarioException("Building " + next + " does not exist");
            }
            b2.setIgnition(true);
        }
        int nextID = 0;
        for (StandardEntity next : model) {
            nextID = Math.max(nextID, next.getID().getValue());
        }
        Logger.debug((String)("Creating " + this.fbLocations.size() + " fire brigades"));
        for (int next : this.fbLocations) {
            id = new EntityID(next);
            FireBrigade f = new FireBrigade(new EntityID(++nextID));
            this.setupAgent((Human)f, id, model, config);
        }
        Logger.debug((String)("Creating " + this.pfLocations.size() + " police forces"));
        for (int next : this.pfLocations) {
            id = new EntityID(next);
            PoliceForce p = new PoliceForce(new EntityID(++nextID));
            this.setupAgent((Human)p, id, model, config);
        }
        Logger.debug((String)("Creating " + this.atLocations.size() + " ambulance teams"));
        for (int next : this.atLocations) {
            id = new EntityID(next);
            AmbulanceTeam a = new AmbulanceTeam(new EntityID(++nextID));
            this.setupAgent((Human)a, id, model, config);
        }
        Logger.debug((String)("Creating " + this.fsLocations.size() + " fire stations"));
        for (int next : this.fsLocations) {
            id = new EntityID(next);
            Logger.debug((String)("Coverting building " + next + " to a fire station"));
            b = (Building)model.getEntity(id);
            if (b == null) {
                throw new ScenarioException("Building " + next + " does not exist");
            }
            FireStation f = new FireStation(b);
            model.removeEntity((Entity)b);
            model.addEntity((Entity)f);
            Logger.debug((String)("Converted " + b + " into " + f));
        }
        Logger.debug((String)("Creating " + this.poLocations.size() + " police offices"));
        for (int next : this.poLocations) {
            id = new EntityID(next);
            Logger.debug((String)("Coverting building " + next + " to a police office"));
            b = (Building)model.getEntity(id);
            if (b == null) {
                throw new ScenarioException("Building " + next + " does not exist");
            }
            PoliceOffice p = new PoliceOffice(b);
            model.removeEntity((Entity)b);
            model.addEntity((Entity)p);
            Logger.debug((String)("Converted " + b + " into " + p));
        }
        Logger.debug((String)("Creating " + this.acLocations.size() + " ambulance centres"));
        for (int next : this.acLocations) {
            id = new EntityID(next);
            Logger.debug((String)("Coverting building " + next + " to an ambulance centre"));
            b = (Building)model.getEntity(id);
            if (b == null) {
                throw new ScenarioException("Building " + next + " does not exist");
            }
            AmbulanceCentre a = new AmbulanceCentre(b);
            model.removeEntity((Entity)b);
            model.addEntity((Entity)a);
            Logger.debug((String)("Converted " + b + " into " + a));
        }
        Logger.debug((String)("Creating " + this.civLocations.size() + " civilians"));
        for (int next : this.civLocations) {
            id = new EntityID(next);
            Civilian c = new Civilian(new EntityID(++nextID));
            this.setupAgent((Human)c, id, model, config);
        }
    }

    public Set<Integer> getFires() {
        return Collections.unmodifiableSet(this.fires);
    }

    public Set<Integer> getRefuges() {
        return Collections.unmodifiableSet(this.refuges);
    }

    public Collection<Integer> getCivilians() {
        return Collections.unmodifiableCollection(this.civLocations);
    }

    public Collection<Integer> getFireBrigades() {
        return Collections.unmodifiableCollection(this.fbLocations);
    }

    public Collection<Integer> getFireStations() {
        return Collections.unmodifiableCollection(this.fsLocations);
    }

    public Collection<Integer> getPoliceForces() {
        return Collections.unmodifiableCollection(this.pfLocations);
    }

    public Collection<Integer> getPoliceOffices() {
        return Collections.unmodifiableCollection(this.poLocations);
    }

    public Collection<Integer> getAmbulanceTeams() {
        return Collections.unmodifiableCollection(this.atLocations);
    }

    public Collection<Integer> getAmbulanceCentres() {
        return Collections.unmodifiableCollection(this.acLocations);
    }

    public void setFires(Set<Integer> newLocations) {
        this.fires.clear();
        this.fires.addAll(newLocations);
    }

    public void setRefuges(Set<Integer> newLocations) {
        this.refuges.clear();
        this.refuges.addAll(newLocations);
    }

    public void setCivilians(Collection<Integer> newLocations) {
        this.civLocations.clear();
        this.civLocations.addAll(newLocations);
    }

    public void setFireBrigades(Collection<Integer> newLocations) {
        this.fbLocations.clear();
        this.fbLocations.addAll(newLocations);
    }

    public void setFireStations(Collection<Integer> newLocations) {
        this.fsLocations.clear();
        this.fsLocations.addAll(newLocations);
    }

    public void setPoliceForces(Collection<Integer> newLocations) {
        this.pfLocations.clear();
        this.pfLocations.addAll(newLocations);
    }

    public void setPoliceOffices(Collection<Integer> newLocations) {
        this.poLocations.clear();
        this.poLocations.addAll(newLocations);
    }

    public void setAmbulanceTeams(Collection<Integer> newLocations) {
        this.atLocations.clear();
        this.atLocations.addAll(newLocations);
    }

    public void setAmbulanceCentres(Collection<Integer> newLocations) {
        this.acLocations.clear();
        this.acLocations.addAll(newLocations);
    }

    public void addFire(int location) {
        this.fires.add(location);
    }

    public void removeFire(int location) {
        this.fires.remove(location);
    }

    public void addRefuge(int location) {
        this.refuges.add(location);
    }

    public void removeRefuge(int location) {
        this.refuges.remove(location);
    }

    public void addCivilian(int location) {
        this.civLocations.add(location);
    }

    public void removeCivilian(int location) {
        this.civLocations.remove(location);
    }

    public void addFireBrigade(int location) {
        this.fbLocations.add(location);
    }

    public void removeFireBrigade(int location) {
        this.fbLocations.remove(location);
    }

    public void addFireStation(int location) {
        this.fsLocations.add(location);
    }

    public void removeFireStation(int location) {
        this.fsLocations.remove(location);
    }

    public void addPoliceForce(int location) {
        this.pfLocations.add(location);
    }

    public void removePoliceForce(int location) {
        this.pfLocations.remove(location);
    }

    public void addPoliceOffice(int location) {
        this.poLocations.add(location);
    }

    public void removePoliceOffice(int location) {
        this.poLocations.remove(location);
    }

    public void addAmbulanceTeam(int location) {
        this.atLocations.add(location);
    }

    public void removeAmbulanceTeam(int location) {
        this.atLocations.remove(location);
    }

    public void addAmbulanceCentre(int location) {
        this.acLocations.add(location);
    }

    public void removeAmbulanceCentre(int location) {
        this.acLocations.remove(location);
    }

    private void setupAgent(Human h, EntityID position, StandardWorldModel model, Config config) throws ScenarioException {
        Entity areaEntity = model.getEntity(position);
        if (areaEntity == null) {
            throw new ScenarioException("Area " + position + " does not exist");
        }
        if (!(areaEntity instanceof Area)) {
            throw new ScenarioException("Entity " + position + " is not an area: " + areaEntity);
        }
        Area area = (Area)areaEntity;
        h.setX(area.getX());
        h.setY(area.getY());
        h.setPosition(position);
        h.setStamina(10000);
        h.setHP(10000);
        h.setDamage(0);
        h.setBuriedness(0);
        h.setDirection(0);
        h.setTravelDistance(0);
        h.setPositionHistory(new int[0]);
        if (h instanceof FireBrigade) {
            ((FireBrigade)h).setWater(config.getIntValue(WATER_QUANTITY_KEY));
        }
        model.addEntity((Entity)h);
        Logger.debug((String)("Created " + h));
    }
}

