/*
 * Decompiled with CFR 0.152.
 */
package traffic3.objects;

import com.infomatiq.jsi.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import rescuecore2.misc.geometry.Line2D;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.Edge;
import traffic3.objects.TrafficAgent;
import traffic3.objects.TrafficBlockade;

public class TrafficArea {
    private Collection<TrafficAgent> agents;
    private Collection<TrafficBlockade> blocks;
    private List<Line2D> blockingLines;
    private List<Line2D> blockadeLines;
    private List<Line2D> allBlockingLines;
    private Area area;
    private Rectangle bounds;

    public TrafficArea(Area area) {
        this.area = area;
        this.agents = new HashSet<TrafficAgent>();
        this.blocks = new HashSet<TrafficBlockade>();
        this.blockingLines = null;
        this.blockadeLines = null;
        this.allBlockingLines = null;
        Rectangle2D r = area.getShape().getBounds2D();
        this.bounds = new Rectangle((float)r.getMinX(), (float)r.getMinY(), (float)r.getMaxX(), (float)r.getMaxY());
    }

    public Area getArea() {
        return this.area;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public List<Line2D> getBlockingLines() {
        if (this.blockingLines == null) {
            this.blockingLines = new ArrayList<Line2D>();
            for (Edge edge : this.area.getEdges()) {
                if (edge.isPassable()) continue;
                this.blockingLines.add(edge.getLine());
            }
        }
        return Collections.unmodifiableList(this.blockingLines);
    }

    public List<Line2D> getBlockadeLines() {
        if (this.blockadeLines == null) {
            this.blockadeLines = new ArrayList<Line2D>();
            for (TrafficBlockade block : this.blocks) {
                this.blockadeLines.addAll(block.getLines());
            }
        }
        return Collections.unmodifiableList(this.blockadeLines);
    }

    public List<Line2D> getAllBlockingLines() {
        if (this.allBlockingLines == null) {
            this.allBlockingLines = new ArrayList<Line2D>();
            this.allBlockingLines.addAll(this.getBlockingLines());
            this.allBlockingLines.addAll(this.getBlockadeLines());
        }
        return Collections.unmodifiableList(this.allBlockingLines);
    }

    public boolean contains(double x, double y) {
        return this.area.getShape().contains(x, y);
    }

    public void addAgent(TrafficAgent agent) {
        this.agents.add(agent);
    }

    public void removeAgent(TrafficAgent agent) {
        this.agents.remove(agent);
    }

    public Collection<TrafficAgent> getAgents() {
        return Collections.unmodifiableCollection(this.agents);
    }

    public void addBlockade(TrafficBlockade block) {
        this.blocks.add(block);
        this.clearBlockadeCache();
    }

    public void removeBlockade(TrafficBlockade block) {
        this.blocks.remove(block);
        this.clearBlockadeCache();
    }

    public void clearBlockadeCache() {
        this.blockadeLines = null;
        this.allBlockingLines = null;
    }

    public Collection<TrafficBlockade> getBlockades() {
        return Collections.unmodifiableCollection(this.blocks);
    }

    public String toString() {
        return "TrafficArea (" + this.area + ")";
    }
}

