/*
 * Decompiled with CFR 0.152.
 */
package gis2.scenario;

import gis2.scenario.ScenarioEditor;
import gis2.scenario.ShapeTool;
import javax.swing.undo.AbstractUndoableEdit;
import maps.gml.GMLShape;

public class PlaceFireBrigadeTool
extends ShapeTool {
    public PlaceFireBrigadeTool(ScenarioEditor editor) {
        super(editor);
    }

    @Override
    public String getName() {
        return "Place fire brigade";
    }

    @Override
    protected boolean shouldHighlight(GMLShape shape) {
        return true;
    }

    @Override
    protected void processClick(GMLShape shape) {
        this.editor.getScenario().addFireBrigade(shape.getID());
        this.editor.setChanged();
        this.editor.updateOverlays();
        this.editor.addEdit(new AddFireBrigadeEdit(shape.getID()));
    }

    private class AddFireBrigadeEdit
    extends AbstractUndoableEdit {
        private int id;

        public AddFireBrigadeEdit(int id) {
            this.id = id;
        }

        @Override
        public void undo() {
            super.undo();
            PlaceFireBrigadeTool.this.editor.getScenario().removeFireBrigade(this.id);
            PlaceFireBrigadeTool.this.editor.updateOverlays();
        }

        @Override
        public void redo() {
            super.redo();
            PlaceFireBrigadeTool.this.editor.getScenario().addFireBrigade(this.id);
            PlaceFireBrigadeTool.this.editor.updateOverlays();
        }
    }
}

