/*
 * Decompiled with CFR 0.152.
 */
package human;

import human.ControlledAmbulanceTeam;
import human.ControlledFireBrigade;
import human.ControlledPoliceForce;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import rescuecore2.components.Agent;
import rescuecore2.components.ComponentConnectionException;
import rescuecore2.components.ComponentLauncher;
import rescuecore2.components.TCPComponentLauncher;
import rescuecore2.config.Config;
import rescuecore2.config.ConfigException;
import rescuecore2.connection.ConnectionException;
import rescuecore2.log.Logger;
import rescuecore2.messages.control.KVTimestep;
import rescuecore2.misc.CommandLineOptions;
import rescuecore2.standard.components.StandardViewer;
import rescuecore2.standard.entities.Building;
import rescuecore2.standard.entities.Human;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.view.StandardWorldModelViewer;
import rescuecore2.view.RenderedObject;
import rescuecore2.view.ViewComponent;
import rescuecore2.view.ViewListener;

public class ControlledAgentGUI
extends JPanel {
    private static final int VIEW_SIZE = 500;
    private List<ControlledFireBrigade> fbs = new ArrayList<ControlledFireBrigade>();
    private ListListModel fbListModel = new ListListModel(this.fbs);
    private JList fbList = new JList(this.fbListModel);
    private List<ControlledPoliceForce> pfs = new ArrayList<ControlledPoliceForce>();
    private ListListModel pfListModel = new ListListModel(this.pfs);
    private JList pfList = new JList(this.pfListModel);
    private List<ControlledAmbulanceTeam> ats = new ArrayList<ControlledAmbulanceTeam>();
    private ListListModel atListModel = new ListListModel(this.ats);
    private JList atList = new JList(this.atListModel);

    public ControlledAgentGUI(StandardWorldModelViewer view) {
        super(new BorderLayout());
        JPanel agents = new JPanel(new GridLayout(3, 1));
        JScrollPane scroll = new JScrollPane(this.fbList);
        scroll.setBorder(BorderFactory.createTitledBorder("Fire brigades"));
        agents.add(scroll);
        scroll = new JScrollPane(this.pfList);
        scroll.setBorder(BorderFactory.createTitledBorder("Police forces"));
        agents.add(scroll);
        scroll = new JScrollPane(this.atList);
        scroll.setBorder(BorderFactory.createTitledBorder("Ambulance teams"));
        agents.add(scroll);
        this.add((Component)agents, "West");
        this.add((Component)view, "Center");
        view.addViewListener(new ViewListener(){

            public void objectsClicked(ViewComponent view, List<RenderedObject> objects) {
                ControlledAgentGUI.this.handleClick(objects);
            }

            public void objectsRollover(ViewComponent view, List<RenderedObject> objects) {
            }
        });
    }

    public static void main(String[] args) {
        Config config = new Config();
        try {
            CommandLineOptions.processArgs((String[])args, (Config)config);
        }
        catch (ConfigException e) {
            Logger.error((String)"Configuration error", (Throwable)e);
            System.exit(-1);
        }
        catch (IOException e) {
            Logger.error((String)"Configuration error", (Throwable)e);
            System.exit(-1);
        }
        StandardWorldModelViewer view = new StandardWorldModelViewer();
        view.setPreferredSize(new Dimension(500, 500));
        ControlledAgentGUI gui = new ControlledAgentGUI(view);
        JFrame frame = new JFrame("Controlled agents");
        frame.add(gui);
        frame.pack();
        frame.setVisible(true);
        int port = config.getIntValue("kernel.port", 7000);
        String host = config.getValue("kernel.host", "localhost");
        TCPComponentLauncher launcher = new TCPComponentLauncher(host, port, config);
        ControlViewer viewer = new ControlViewer(view, gui);
        try {
            launcher.connect((rescuecore2.components.Component)viewer);
        }
        catch (InterruptedException e) {
            Logger.error((String)"Interrupted", (Throwable)e);
            System.exit(-1);
        }
        catch (ConnectionException e) {
            Logger.error((String)"Viewer connection failed", (Throwable)e);
            System.exit(-1);
        }
        catch (ComponentConnectionException e) {
            Logger.error((String)"Viewer connection failed", (Throwable)e);
            System.exit(-1);
        }
        gui.launchAgents((ComponentLauncher)launcher);
    }

    private void launchAgents(ComponentLauncher launcher) {
        new AgentConnector(launcher).start();
    }

    private void refreshLists() {
        this.fbListModel.refresh();
        this.pfListModel.refresh();
        this.atListModel.refresh();
    }

    private void handleClick(List<RenderedObject> clicked) {
        this.handleFBClick(clicked);
        this.handlePFClick(clicked);
        this.handleATClick(clicked);
    }

    private void handleFBClick(List<RenderedObject> clicked) {
        for (RenderedObject next : clicked) {
            if (!(next.getObject() instanceof Building)) continue;
            Building b = (Building)next.getObject();
            for (ControlledFireBrigade agent : this.getSelectedFireBrigades()) {
                agent.setTarget(b);
            }
        }
        this.fbListModel.refresh();
    }

    private void handlePFClick(List<RenderedObject> clicked) {
        for (RenderedObject next : clicked) {
            if (!(next.getObject() instanceof Road)) continue;
            Road r = (Road)next.getObject();
            for (ControlledPoliceForce agent : this.getSelectedPoliceForces()) {
                agent.setTarget(r);
            }
        }
        this.pfListModel.refresh();
    }

    private void handleATClick(List<RenderedObject> clicked) {
        for (RenderedObject next : clicked) {
            if (!(next.getObject() instanceof Human)) continue;
            Human h = (Human)next.getObject();
            for (ControlledAmbulanceTeam agent : this.getSelectedAmbulanceTeams()) {
                agent.setTarget(h);
            }
        }
        this.atListModel.refresh();
    }

    private List<ControlledFireBrigade> getSelectedFireBrigades() {
        int[] selected = this.fbList.getSelectedIndices();
        ArrayList<ControlledFireBrigade> agents = new ArrayList<ControlledFireBrigade>(selected.length);
        for (int next : selected) {
            agents.add(this.fbs.get(next));
        }
        return agents;
    }

    private List<ControlledPoliceForce> getSelectedPoliceForces() {
        int[] selected = this.pfList.getSelectedIndices();
        ArrayList<ControlledPoliceForce> agents = new ArrayList<ControlledPoliceForce>(selected.length);
        for (int next : selected) {
            agents.add(this.pfs.get(next));
        }
        return agents;
    }

    private List<ControlledAmbulanceTeam> getSelectedAmbulanceTeams() {
        int[] selected = this.atList.getSelectedIndices();
        ArrayList<ControlledAmbulanceTeam> agents = new ArrayList<ControlledAmbulanceTeam>(selected.length);
        for (int next : selected) {
            agents.add(this.ats.get(next));
        }
        return agents;
    }

    private static class AmbulanceTeamAgentType
    implements AgentType<ControlledAmbulanceTeam> {
        private AmbulanceTeamAgentType() {
        }

        @Override
        public ControlledAmbulanceTeam createAgent() {
            return new ControlledAmbulanceTeam();
        }

        public String toString() {
            return "ambulance team";
        }
    }

    private static class PoliceForceAgentType
    implements AgentType<ControlledPoliceForce> {
        private PoliceForceAgentType() {
        }

        @Override
        public ControlledPoliceForce createAgent() {
            return new ControlledPoliceForce();
        }

        public String toString() {
            return "police force";
        }
    }

    private static class FireBrigadeAgentType
    implements AgentType<ControlledFireBrigade> {
        private FireBrigadeAgentType() {
        }

        @Override
        public ControlledFireBrigade createAgent() {
            return new ControlledFireBrigade();
        }

        public String toString() {
            return "fire brigade";
        }
    }

    private static interface AgentType<T extends Agent> {
        public T createAgent();
    }

    private class AgentConnector
    extends Thread {
        private ComponentLauncher launcher;

        public AgentConnector(ComponentLauncher launcher) {
            this.launcher = launcher;
        }

        @Override
        public void run() {
            this.connectAgents(new FireBrigadeAgentType(), ControlledAgentGUI.this.fbs, ControlledAgentGUI.this.fbListModel);
            this.connectAgents(new PoliceForceAgentType(), ControlledAgentGUI.this.pfs, ControlledAgentGUI.this.pfListModel);
            this.connectAgents(new AmbulanceTeamAgentType(), ControlledAgentGUI.this.ats, ControlledAgentGUI.this.atListModel);
        }

        private <T extends Agent> void connectAgents(AgentType<T> type, List<? super T> list, ListListModel model) {
            int count = 0;
            while (true) {
                ++count;
                T agent = type.createAgent();
                try {
                    this.launcher.connect(agent);
                    list.add(agent);
                }
                catch (ComponentConnectionException e) {
                    break;
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (ConnectionException e) {
                    break;
                }
            }
            model.refresh();
        }
    }

    private static class ListListModel
    extends AbstractListModel {
        private List<?> data;

        public ListListModel(List<?> data) {
            this.data = data;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, this.data.size());
        }
    }

    private static class ControlViewer
    extends StandardViewer {
        private StandardWorldModelViewer view;
        private ControlledAgentGUI gui;

        public ControlViewer(StandardWorldModelViewer view, ControlledAgentGUI gui) {
            this.view = view;
            this.gui = gui;
        }

        protected void postConnect() {
            this.view.view(new Object[]{this.model});
        }

        protected void handleTimestep(KVTimestep t) {
            super.handleTimestep(t);
            this.view.repaint();
            this.gui.refreshLists();
        }
    }
}

