/*
 * Decompiled with CFR 0.152.
 */
package human;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;
import rescuecore2.misc.Pair;
import rescuecore2.standard.components.StandardAgent;
import rescuecore2.standard.entities.Area;
import rescuecore2.standard.entities.PoliceForce;
import rescuecore2.standard.entities.Road;
import rescuecore2.standard.entities.StandardEntity;
import rescuecore2.standard.entities.StandardEntityURN;
import rescuecore2.standard.entities.StandardWorldModel;
import rescuecore2.worldmodel.ChangeSet;
import rescuecore2.worldmodel.EntityID;
import sample.SampleSearch;

public class ControlledPoliceForce
extends StandardAgent<PoliceForce> {
    private SampleSearch search;
    private Road target;

    public void setTarget(Road target) {
        this.target = target;
    }

    protected void think(int time, ChangeSet changed, Collection<Command> heard) {
        if (this.location() instanceof Road) {
            Road r = (Road)this.location();
            EntityID nearest = this.getNearestBlockade();
            if (nearest != null) {
                this.sendClear(time, nearest);
                return;
            }
        }
        if (this.target == null) {
            Logger.info((String)"Nothing to do.");
            return;
        }
        List path = this.search.breadthFirstSearch(((PoliceForce)this.me()).getPosition(), new EntityID[]{this.target.getID()});
        if (path != null) {
            this.sendMove(time, path);
            return;
        }
        Logger.info((String)"Couldn't plan a path to target.");
    }

    protected EnumSet<StandardEntityURN> getRequestedEntityURNsEnum() {
        return EnumSet.of(StandardEntityURN.POLICE_FORCE);
    }

    protected StandardEntity location() {
        PoliceForce me = (PoliceForce)this.me();
        return me.getPosition(this.model);
    }

    protected void postConnect() {
        super.postConnect();
        this.search = new SampleSearch((StandardWorldModel)this.model);
    }

    public String toString() {
        if (this.me() == null) {
            return "Human controlled police force";
        }
        return "Human controlled police force " + this.getID() + (this.target == null ? " (no target)" : " target: road " + this.target.getID() + " with " + (this.target.isBlockadesDefined() ? " unknown" : String.valueOf(this.target.getBlockades().size())) + " blockades");
    }

    public EntityID getNearestBlockade() {
        return this.getNearestBlockade((Area)this.location(), ((PoliceForce)this.me()).getX(), ((PoliceForce)this.me()).getY());
    }

    public EntityID getNearestBlockade(Area area, int x, int y) {
        double bestDistance = 0.0;
        EntityID best = null;
        if (area.isBlockadesDefined()) {
            for (EntityID blockadeID : area.getBlockades()) {
                StandardEntity entity = (StandardEntity)((StandardWorldModel)this.model).getEntity(blockadeID);
                Pair location = entity.getLocation(this.model);
                if (location == null) continue;
                double dx = (Integer)location.first() - x;
                double dy = (Integer)location.second() - y;
                double distance = Math.hypot(dx, dy);
                if (best != null && !(distance < bestDistance)) continue;
                bestDistance = distance;
                best = entity.getID();
            }
        }
        return best;
    }
}

