/*
 * Decompiled with CFR 0.152.
 */
package kernel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kernel.AgentProxy;
import kernel.CommandCollector;
import rescuecore2.config.Config;
import rescuecore2.log.Logger;
import rescuecore2.messages.Command;

public class CompositeCommandCollector
implements CommandCollector {
    private Set<CommandCollector> children = new HashSet<CommandCollector>();

    @Override
    public void initialise(Config config) {
        for (CommandCollector next : this.children) {
            next.initialise(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<Command> getAgentCommands(Collection<AgentProxy> agents, int timestep) throws InterruptedException {
        if (agents.size() == 0) {
            return new HashSet<Command>();
        }
        ExecutorCompletionService<Collection<Command>> service = new ExecutorCompletionService<Collection<Command>>(Executors.newFixedThreadPool(agents.size()));
        HashSet<Future<Collection<Command>>> futures = new HashSet<Future<Collection<Command>>>();
        for (CommandCollector next : this.children) {
            futures.add(service.submit(new ChildCommandsFetcher(next, agents, timestep)));
        }
        try {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                try {
                    Collection collection = (Collection)service.take().get();
                    return collection;
                }
                catch (ExecutionException e) {
                    try {
                        Logger.error((String)"Error while getting agent commands", (Throwable)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return new HashSet<Command>();
                    }
                }
            }
        }
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    public void addCommandCollector(CommandCollector child) {
        this.children.add(child);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("CompositeCommandCollector [");
        Iterator<CommandCollector> it = this.children.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    private static final class ChildCommandsFetcher
    implements Callable<Collection<Command>> {
        private CommandCollector child;
        private Collection<AgentProxy> agents;
        private int timestep;

        ChildCommandsFetcher(CommandCollector child, Collection<AgentProxy> agents, int timestep) {
            this.child = child;
            this.agents = agents;
            this.timestep = timestep;
        }

        @Override
        public Collection<Command> call() throws Exception {
            return this.child.getAgentCommands(this.agents, this.timestep);
        }
    }
}

