package org.util.xml;

import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;
import java.net.*;
import javax.swing.*;
import javax.swing.event.*;

import org.util.xml.element.*;
import org.util.xml.parse.*;
import org.util.xml.parse.policy.*;
import org.util.xml.renderer.html.*;

import static org.gui.GUITool.alert;
import static org.gui.GUITool.showFrame;

/**
 *
 * @author masaru
 */
public class Main5 {
    
    private JPanel panel_;
    private JTextArea text_area_;
    private String doctype_;
    private JTextField text_;

    private ParserPolicy keep_all_parser_;
    private ParserPolicy body_tag_parser_;
    private ParserPolicy html_tag_parser_;
    private ParserPolicy html_document_parser_;



    public static void main(String[] args) throws Exception {

	final Main5 main = new Main5();
	main.start();
	main.openInOtherThread("http://sakura.meijo-u.ac.jp/index.html");
    }

    public Main5() {
	
    }

    public void start() throws Exception {
	//org.gui.GUITool.tryToSetSystemLookAndFeel();

	SwingUtilities.invokeAndWait(new Runnable(){public void run() {
	    text_ = new JTextField();
	    text_.addActionListener(new ActionListener(){
		    public void actionPerformed(ActionEvent e) {
			String url_text = text_.getText();
			openInOtherThread(url_text);
		    }
		});

	    JPanel menu = new JPanel();
	    menu.setLayout(new BoxLayout(menu, BoxLayout.X_AXIS));
	    menu.setPreferredSize(new Dimension(500, 30));
	    menu.add(text_);
	    
	    JPanel contentpane = new JPanel(new BorderLayout());
	    contentpane.setPreferredSize(new Dimension(500, 400));
	    //text_area_ = new JTextArea();
	    //contentpane.add(new JScrollPane(text_area_), BorderLayout.CENTER);
	    panel_ = new JPanel();
	    panel_.setLayout(new BoxLayout(panel_, BoxLayout.Y_AXIS));
	    //panel_.setPreferredSize(new Dimension(500, 400));
	    contentpane.add(menu, BorderLayout.NORTH);
	    contentpane.add(new JScrollPane(panel_), BorderLayout.CENTER);
	    showFrame(contentpane, JFrame.EXIT_ON_CLOSE);
	}});


	
	keep_all_parser_ = new HTMLParserPolicy() {
		public ParserPolicy getInnerPolicy(Element element) {
		    return this;
		}
		public Element allowElement(Element element) {
		    return element;
		}
	    };


	body_tag_parser_ = new HTMLParserPolicy() {
		public ParserPolicy getInnerPolicy(Element element) {
		    TagElement tag = (TagElement)element;
		    /*
		    if(tag.getKey().toLowerCase().equals("html"))
			return html_tag_parser;
		    */
		    return this;
		}
		public Element allowElement(Element element) {
		    //panel_.add(new JButton(element.toString()));
		    if(!element.isTagElement()) {
			JLabel label = new JLabel(((TextElement)element).getValue());
			label.setBackground(Color.green);
			panel_.add(label);
		    }else{
			TagElement tag = (TagElement)element;
			String key = tag.getKey().toLowerCase();
			if(key.equals("a")) {
			    
			}else{
			    JLabel label = new JLabel("<html>"+tag.toString()+"</html>");
			    label.setBorder(BorderFactory.createLineBorder(Color.blue));
			    label.setToolTipText(tag.toString());
			    panel_.add(label);
			}
		    }
		    panel_.revalidate();
		    return null;
		}
	    };



	html_tag_parser_ = new HTMLParserPolicy() {
		public ParserPolicy getInnerPolicy(Element element) {
		    if(!element.isTagElement()) return keep_all_parser_;
		    TagElement tag = ((TagElement)element);
		    if(tag.getKey().toLowerCase().equals("body"))
			return body_tag_parser_;
		    return keep_all_parser_;
		}
		public Element allowElement(Element element) {
		    //panel_.add(new JButton(element.toString()));
		    return element;
		}
	    };

	html_document_parser_ = new HTMLParserPolicy() {
		public ParserPolicy getInnerPolicy(Element element) {
		    TagElement tag = (TagElement)element;
		    if(tag.getKey().toLowerCase().equals("html"))
			return html_tag_parser_;
		    return keep_all_parser_;
		}
		public Element allowElement(Element element) {
		    if(element.isTextElement()) {
			TextElement text_tag = (TextElement)element;
			String text = text_tag.getValue();
			if(text.toLowerCase().startsWith("doctype")) {
			    doctype_ = text;
			    return null;
			}
		    }
		    return null;
		}
	    };


    }

    public void openInOtherThread(final String url_text) {
	new Thread(new Runnable(){public void run(){
	    try{
		open(url_text);
	    }catch(Exception e){e.printStackTrace();}
	}}, "open url").start();
    }

    public void open(String url_text) throws Exception {
	panel_.removeAll();

	URL url = new URL(url_text);
	ElementParser parser = new ElementParser(url.openStream());
	parser.setDocumentBase(url.toURI());

	alert("now starting parse");

	parser.setPolicy(html_document_parser_);
	parser.parse();

	panel_.revalidate();
    }










    
    public void oldMain5() throws Exception {
	String text = "<img src=\"http://www.google.com/intl/en_ALL/images/logo.gif\"/><div>aaabbbccc</div>";
	//		ElementParser parser = new ElementParser(new StringReader(text));
	//		ElementParser parser = new ElementParser(new URL("http://sakura.meijo-u.ac.jp/index.html").openStream());
	URL url = new URL("http://www.google.com/index.html");
	//		URL url = new URL("http://video.google.com/?hl=ja&tab=wv");
	ElementParser parser = new ElementParser(url.openStream());
	parser.setDocumentBase(url.toURI());
	
	final HTMLObject htmlo = new HTMLObject();
	parser.setPolicy(htmlo);
	parser.parse();
	
	final JComponent comp = new JComponent() {
		public void paint(Graphics g) {
		    htmlo.paint(g);
		}
	    };
	comp.addMouseListener(new MouseListener(){
		public void mousePressed(MouseEvent e) {
		    if(htmlo.hit(e.getX(), e.getY()))
			htmlo.mousePressed(e);
		}
		public void mouseReleased(MouseEvent e) {
		    if(htmlo.hit(e.getX(), e.getY()))
			htmlo.mouseReleased(e);
		}
		public void mouseClicked(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseClicked(e);
			}
			public void mouseEntered(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseEntered(e);
			}
			public void mouseExited(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseExited(e);
			}
		});
		comp.addMouseMotionListener(new MouseMotionListener(){
			public void mouseMoved(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY())) {
					htmlo.mouseMoved(e);
					if(!htmlo.is_mouse_over_) {
						htmlo.is_mouse_over_ = true;
						htmlo.mouseEntered(e);
					}
				} else {
					if(htmlo.is_mouse_over_) {
						htmlo.is_mouse_over_ = false;
						htmlo.mouseExited(e);
					}
				}
			}
			public void mouseDragged(MouseEvent e) {
				if(htmlo.hit(e.getX(), e.getY()))
					htmlo.mouseDragged(e);
			}
		});
		comp.addMouseWheelListener(new MouseWheelListener(){
			public void mouseWheelMoved(MouseWheelEvent e) {
				htmlo.mouseWheelMoved(e);
			}
		});

		htmlo.addChangeListener(new ChangeListener(){
			public void stateChanged(ChangeEvent e) {
				comp.repaint();
			}
		});

		JPanel panel = new JPanel(new BorderLayout());
		panel.add(comp, BorderLayout.CENTER);
		
		JFrame frame = new JFrame();
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setContentPane(panel);
		frame.pack();
		frame.setBounds(100,100, 500, 500);
		frame.setVisible(true);
		
	}
}
